%SURFACEFORCING Class definition
%
%   Usage:
%      surfaceforcings=surfaceforcings();

classdef surfaceforcings
	properties (SetAccess=public) 
		precipitation = NaN;
		mass_balance  = NaN;
		ispdd = 0;
		issmbgradients = 0;
	   hc = NaN;
		smb_pos_max = NaN;
		smb_pos_min = NaN;
		a_pos = NaN;
		b_pos = NaN;
		a_neg = NaN;
		b_neg = NaN;
		monthlytemperatures = NaN;
	end
	methods
		function obj = surfaceforcings(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{
		  
		  %pdd method not used in default mode
		  obj.ispdd=0;
		  obj.issmbgradients=0;

		end % }}}
		function md = checkconsistency(obj,md,solution,analyses) % {{{

			if ismember(PrognosticAnalysisEnum,analyses),
				md = checkfield(md,'surfaceforcings.ispdd','numel',1,'values',[0 1]);
				checkfield(md,'surfaceforcings.issmbgradients','numel',1,'values',[0 1]);
				if(obj.ispdd)
					md = checkfield(md,'surfaceforcings.monthlytemperatures','forcing',1,'NaN',1);
				elseif(obj.issmbgradients)
					checkfield(md,'surfaceforcings.hc','forcing',1,'NaN',1);
					checkfield(md,'surfaceforcings.smb_pos_max','forcing',1,'NaN',1);
					checkfield(md,'surfaceforcings.smb_pos_min','forcing',1,'NaN',1);
					checkfield(md,'surfaceforcings.a_pos','forcing',1,'NaN',1);
					checkfield(md,'surfaceforcings.b_pos','forcing',1,'NaN',1);
					checkfield(md,'surfaceforcings.a_neg','forcing',1,'NaN',1);
					checkfield(md,'surfaceforcings.b_neg','forcing',1,'NaN',1);
				else
					md = checkfield(md,'surfaceforcings.mass_balance','forcing',1,'NaN',1);
				end
			end
			if ismember(BalancethicknessAnalysisEnum,analyses),
				md = checkfield(md,'surfaceforcings.mass_balance','size',[md.mesh.numberofvertices 1],'NaN',1);
			end
		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   surface forcings parameters:'));

			fielddisplay(obj,'precipitation','surface precipitation [m/yr water eq]');
			fielddisplay(obj,'mass_balance','surface mass balance [m/yr ice eq]');
			fielddisplay(obj,'ispdd','is pdd activated (0 or 1, default is 0)');
			fielddisplay(obj,'monthlytemperatures','monthly surface temperatures required if pdd is activated');
			fielddisplay(obj,'issmbgradients','is smb gradients method activated (0 or 1, default is 0)');
			fielddisplay(obj,'hc',' elevation of intersection between accumulation and ablation regime required if smb gradients is activated');
			fielddisplay(obj,'smb_pos_max',' maximum value of positive smb required if smb gradients is activated');
			fielddisplay(obj,'smb_pos_min',' minimum value of positive smb required if smb gradients is activated');
			fielddisplay(obj,'a_pos',' intercept of hs - smb regression line for accumulation regime required if smb gradients is activated');
			fielddisplay(obj,'b_pos',' slope of hs - smb regression line for accumulation regime required if smb gradients is activated');
			fielddisplay(obj,'a_neg',' intercept of hs - smb regression line for ablation regime required if smb gradients is activated');
			fielddisplay(obj,'b_neg',' slope of hs - smb regression line for ablation regime required if smb gradients is activated');

		end % }}}
		function marshall(obj,fid) % {{{
			WriteData(fid,'object',obj,'fieldname','precipitation','format','DoubleMat','mattype',1);
			WriteData(fid,'object',obj,'fieldname','mass_balance','format','DoubleMat','mattype',1);
			WriteData(fid,'object',obj,'fieldname','ispdd','format','Boolean');
			if obj.ispdd,
				WriteData(fid,'object',obj,'fieldname','monthlytemperatures','format','DoubleMat','mattype',1);
			end
			WriteData(fid,'object',obj,'fieldname','issmbgradients','format','Boolean');
			if obj.issmbgradients,
				WriteData(fid,'object',obj,'fieldname','hc','format','DoubleMat','mattype',1);
				WriteData(fid,'object',obj,'fieldname','smb_pos_max','format','DoubleMat','mattype',1);
				WriteData(fid,'object',obj,'fieldname','smb_pos_min','format','DoubleMat','mattype',1);
				WriteData(fid,'object',obj,'fieldname','a_pos','format','DoubleMat','mattype',1);
				WriteData(fid,'object',obj,'fieldname','b_pos','format','DoubleMat','mattype',1);
				WriteData(fid,'object',obj,'fieldname','a_neg','format','DoubleMat','mattype',1);
				WriteData(fid,'object',obj,'fieldname','b_neg','format','DoubleMat','mattype',1);
			end

		end % }}}
	end
end
