/*!\file: balancethickness_core.cpp
 * \brief: core of the balancethickness solution 
 */ 

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../io/io.h"
#include "../include/include.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "./solutions.h"
#include "../modules/modules.h"
#include "../solvers/solvers.h"

void balancethickness_core(FemModel* femmodel){

	/*parameters: */
	bool save_results;

	/*activate formulation: */
	femmodel->SetCurrentConfiguration(BalancethicknessAnalysisEnum);
	
	/*recover parameters: */
	femmodel->parameters->FindParam(&save_results,SaveResultsEnum);

	if(VerboseSolution()) _pprintLine_("call computational core:");
	solver_linear(femmodel);

	if(save_results){
		if(VerboseSolution()) _pprintLine_("   saving results");
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,ThicknessEnum);
	}

}
