/*!\file:  ProfilingEnd.cpp
 * \brief ProfilingEnd.c: finalize profiling after calling a routine. Needs to mirror a ProfilingStart routine.
 */

/*Include files: {{{*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif
#include "../../include/macros.h"
#include "../shared.h"
#include "../../io/io.h"
/*}}}*/

void ProfilingEnd(double* pSolution_time, double* pMemory_use, double* pCurrent_flops, double Time_start, double Flops_start){

	double Solution_time, Memory_use, Current_flops;
	double Time_finish, Flops_finish, memUse;
	
	#ifdef _HAVE_PETSC_
	PetscGetTime(&Time_finish);
	PetscGetFlops(&Flops_finish);
	PetscMemoryGetCurrentUsage(&memUse);
	
	Solution_time=Time_finish-Time_start;
	Current_flops=Flops_finish-Flops_start;
	_pprintLine_("PETSc elapsed time  : " << Solution_time << "  Seconds");
	_pprintLine_("PETSc elapsed flops : " << Current_flops << "  Flops");
	_pprintLine_("PETSc memory used   : " << memUse << "  Bytes");
	#else
		_error_("Profiling not supported under this numerical toolkit");
	#endif

	/*Assign pointers: */
	*pSolution_time=Solution_time;
	*pMemory_use=memUse;
	*pCurrent_flops=Current_flops;
	return;
}



