/*!\file DoubleMatParam.c
 * \brief: implementation of the DoubleMatParam object
 */

/*header files: */
/*{{{*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*DoubleMatParam constructors and destructor*/
/*FUNCTION DoubleMatParam::DoubleMatParam(){{{*/
DoubleMatParam::DoubleMatParam(){
	return;
}
/*}}}*/
/*FUNCTION DoubleMatParam::DoubleMatParam(int enum_type,IssmDoubleMat value){{{*/
DoubleMatParam::DoubleMatParam(int in_enum_type,IssmDouble* in_value, int in_M,int in_N){

	enum_type=in_enum_type;
	M=in_M;
	N=in_N;

	value=xNew<IssmDouble>(M*N);
	xMemCpy<IssmDouble>(value,in_value,M*N);
}
/*}}}*/
/*FUNCTION DoubleMatParam::~DoubleMatParam(){{{*/
DoubleMatParam::~DoubleMatParam(){
	xDelete<IssmDouble>(value);
	return;
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION DoubleMatParam::Echo {{{*/
void DoubleMatParam::Echo(void){

	_printLine_("DoubleMatParam:");
	_printLine_("   enum: " << this->enum_type << " (" << EnumToStringx(this->enum_type) << ")");
	_printLine_("   matrix size: " << this->M << "x" << this->N);

}
/*}}}*/
/*FUNCTION DoubleMatParam::DeepEcho{{{*/
void DoubleMatParam::DeepEcho(void){

	int i,j;
	
	_printLine_("DoubleMatParam:");
	_printLine_("   enum: " << this->enum_type << " (" << EnumToStringx(this->enum_type) << ")");
	_printLine_("   matrix size: " << this->M << "x" << this->N);
	for(i=0;i<this->M;i++){
		for(i=0;i<this->N;i++){
			_printLine_(i << " " << j << " " << *(this->value+N*i+j));
		}
	}
}
/*}}}*/
/*FUNCTION DoubleMatParam::Id{{{*/
int    DoubleMatParam::Id(void){ return -1; }
/*}}}*/
/*FUNCTION DoubleMatParam::MyRank{{{*/
int    DoubleMatParam::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
/*FUNCTION DoubleMatParam::ObjectEnum{{{*/
int DoubleMatParam::ObjectEnum(void){

	return DoubleMatParamEnum;

}
/*}}}*/
/*FUNCTION DoubleMatParam::copy{{{*/
Object* DoubleMatParam::copy() {
	
	return new DoubleMatParam(this->enum_type,this->value,this->M,this->N);

}
/*}}}*/

/*DoubleMatParam virtual functions definitions: */
/*FUNCTION DoubleMatParam::GetParameterValue(IssmDouble** pIssmDoublearray,int* pM,int* pN){{{*/
void  DoubleMatParam::GetParameterValue(IssmDouble** pIssmDoublearray,int* pM,int* pN){
	IssmDouble* output=NULL;

	output=xNew<IssmDouble>(M*N);
	xMemCpy<IssmDouble>(output,value,M*N);

	/*Assign output pointers:*/
	if(pM) *pM=M;
	if(pN) *pN=N;
	*pIssmDoublearray=output;
}
/*}}}*/
/*FUNCTION DoubleMatParam::GetParameterValue(int** pintarray,int* pM,int* pN){{{*/
void  DoubleMatParam::GetParameterValue(int** pintarray,int* pM,int* pN){
	_error2_("DoubleMat of enum " << enum_type << " (" << EnumToStringx(enum_type) << ") cannot return an array of int");
}
/*}}}*/
/*FUNCTION DoubleMatParam::GetParameterName{{{*/
void DoubleMatParam::GetParameterName(char**pname){
	EnumToStringx(pname,this->enum_type);
}
/*}}}*/
/*FUNCTION DoubleMatParam::SetValue{{{*/
void  DoubleMatParam::SetValue(IssmDouble* IssmDoublearray,int in_M,int in_N){

	/*avoid leak: */
	xDelete<IssmDouble>(this->value);

	this->value=xNew<IssmDouble>(in_M*in_N);
	xMemCpy<IssmDouble>(this->value,IssmDoublearray,in_M*in_N);

	this->M=in_M;
	this->N=in_N;
}
/*}}}*/
/*FUNCTION DoubleMatParam::UnitConversion{{{*/
void  DoubleMatParam::UnitConversion(int direction_enum){
	::UnitConversion(this->value,this->M*this->N,direction_enum,this->enum_type);
}
/*}}}*/
		
/*diverse: */
/*FUNCTION DoubleMatParam::GetPointer{{{*/
IssmDouble* DoubleMatParam::GetPointer(void){
	return this->value;
}
/*}}}*/
