/*! \file PentaP1Input.h 
 *  \brief: header file for PentaP1Input object
 */


#ifndef _PENTAP1INPUT_H_
#define _PENTAP1INPUT_H_

/*Headers:*/
/*{{{*/
#include "./Input.h"
#include "../Elements/PentaRef.h"
class GaussTria;
/*}}}*/

class PentaP1Input: public Input, public PentaRef{

	public:
		/*just hold 6 values for 6 vertices: */
		int    enum_type;
		IssmDouble values[6];

		/*PentaP1Input constructors, destructors: {{{*/
		PentaP1Input();
		PentaP1Input(int enum_type,IssmDouble* values);
		~PentaP1Input();
		/*}}}*/
		/*Object virtual functions definitions:{{{ */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*PentaP1Input management: {{{*/
		int   InstanceEnum();
		Input* SpawnTriaInput(int* indices);
		Input* PointwiseDivide(Input* inputB);
		Input* PointwiseMin(Input* inputB);
		Input* PointwiseMax(Input* inputB);
		ElementResult* SpawnResult(int step, IssmDouble time);
		void AddTimeValues(IssmDouble* values,int step,IssmDouble time){_error2_("not supported yet");};
		void Configure(Parameters* parameters);
		/*}}}*/
		/*numerics: {{{*/
		void GetInputValue(bool* pvalue){_error2_("not implemented yet");};
		void GetInputValue(int* pvalue){_error2_("not implemented yet");};
		void GetInputValue(IssmDouble* pvalue){_error2_("not implemented yet");};
		void GetInputValue(IssmDouble* pvalue,GaussTria* gauss){_error2_("not implemented yet");};
		void GetInputValue(IssmDouble* pvalue,GaussPenta* gauss);
		void GetInputValue(IssmDouble* pvalue,GaussTria* gauss,IssmDouble time){_error2_("not implemented yet");};
		void GetInputValue(IssmDouble* pvalue,GaussPenta* gauss,IssmDouble time){_error2_("not implemented yet");};
		void GetInputValue(IssmDouble* pvalue,GaussTria* gauss ,int index){_error2_("not implemented yet");};
		void GetInputValue(IssmDouble* pvalue,GaussPenta* gauss ,int index){_error2_("not implemented yet");};
		void GetInputDerivativeValue(IssmDouble* derivativevalues, IssmDouble* xyz_list, GaussTria* gauss){_error2_("not implemented yet");};
		void GetInputDerivativeValue(IssmDouble* derivativevalues, IssmDouble* xyz_list, GaussPenta* gauss);
		void GetInputAverage(IssmDouble* pvalue);
		void GetVxStrainRate2d(IssmDouble* epsilonvx,IssmDouble* xyz_list, GaussTria* gauss){_error2_("not implemented yet");};
		void GetVyStrainRate2d(IssmDouble* epsilonvy,IssmDouble* xyz_list, GaussTria* gauss){_error2_("not implemented yet");};
		void GetVxStrainRate3d(IssmDouble* epsilonvx,IssmDouble* xyz_list, GaussPenta* gauss);
		void GetVyStrainRate3d(IssmDouble* epsilonvy,IssmDouble* xyz_list, GaussPenta* gauss);
		void GetVzStrainRate3d(IssmDouble* epsilonvz,IssmDouble* xyz_list, GaussPenta* gauss);
		void GetVxStrainRate3dPattyn(IssmDouble* epsilonvx,IssmDouble* xyz_list, GaussPenta* gauss);
		void GetVyStrainRate3dPattyn(IssmDouble* epsilonvy,IssmDouble* xyz_list, GaussPenta* gauss);
		void ChangeEnum(int newenumtype);

		void SquareMin(IssmDouble* psquaremin, bool process_units,Parameters* parameters);
		void ConstrainMin(IssmDouble minimum);
		void Scale(IssmDouble scale_factor);
		void ArtificialNoise(IssmDouble min,IssmDouble max){_error2_("not implemented yet");};
		void AXPY(Input* xinput,IssmDouble scalar);
		void Constrain(IssmDouble cm_min, IssmDouble cm_max);
		IssmDouble InfinityNorm(void);
		IssmDouble Max(void);
		IssmDouble MaxAbs(void);
		IssmDouble Min(void);
		IssmDouble MinAbs(void);
		void Extrude(void);
		void VerticallyIntegrate(Input* thickness_input);
		void GetVectorFromInputs(Vector* vector,int* doflist);
		void GetValuesPtr(IssmDouble** pvalues,int* pnum_values);
		/*}}}*/

};
#endif  /* _PENTAP1INPUT_H */
