/*!\file:  Element.h
 * \brief abstract class for Element object
 * This class is a place holder for the Tria and the Penta elements. 
 * It is derived from Element, so DataSets can contain them.
 */ 


#ifndef _ELEMENT_H_
#define _ELEMENT_H_

/*Headers:*/
/*{{{*/
#include "../Object.h"

class DataSet;
class Parameters;
class Patch;
class Matrix;
class Vector;

#include "../../toolkits/toolkits.h"
/*}}}*/

class Element: public Object,public Update{

	public: 
		
		virtual        ~Element(){};
	
		virtual void   Configure(Elements* elements,Loads* loads,DataSet* nodes,Materials* materials,Parameters* parameters)=0;
		virtual void   SetCurrentConfiguration(Elements* elements,Loads* loads,DataSet* nodes,Materials* materials,Parameters* parameters)=0;
		virtual void   CreateKMatrix(Matrix* Kff, Matrix*  Kfs,Vector* df)=0;
		virtual void   CreatePVector(Vector* pf)=0;
		virtual void   CreateJacobianMatrix(Matrix* Jff)=0;
		virtual void   GetSolutionFromInputs(Vector* solution)=0;
		virtual int    GetNodeIndex(Node* node)=0;
		virtual int    Sid()=0;
		virtual bool   IsFloating()=0; 
		virtual bool   IsNodeOnShelf()=0; 
		virtual bool   IsNodeOnShelfFromFlags(IssmDouble* flags)=0; 
		virtual bool   IsOnBed()=0;
		virtual void   GetInputListOnVertices(IssmDouble* pvalue,int enumtype)=0;
		virtual void   GetInputListOnVertices(IssmDouble* pvalue,int enumtype,IssmDouble defaultvalue)=0;
		virtual void   GetInputValue(IssmDouble* pvalue,Node* node,int enumtype)=0;
		
		virtual IssmDouble SurfaceArea(void)=0;
		virtual void   InputDepthAverageAtBase(int enum_type,int average_enum_type,int object_enum)=0;
		virtual void   ComputeBasalStress(Vector* sigma_b)=0;
		virtual void   ComputeStrainRate(Vector* eps)=0;
		virtual void   PatchSize(int* pnumrows, int* pnumvertices,int* pnumnodes)=0;
		virtual void   PatchFill(int* pcount, Patch* patch)=0;
		virtual void   ListResultsInfo(int** results_enums,int** results_size,IssmDouble** results_times,int** results_steps,int* num_results)=0;
		virtual void   DeleteResults(void)=0;
		virtual void   Update(int index, IoModel* iomodel,int analysis_counter,int analysis_type)=0;
		virtual void   InputToResult(int enum_type,int step,IssmDouble time)=0;
		virtual void   InputDuplicate(int original_enum,int new_enum)=0;
		virtual void   InputCreate(IssmDouble scalar,int name,int code)=0;
		virtual void   InputCreate(IssmDouble* vector, int index,IoModel* iomodel,int M,int N,int vector_type,int vector_enum,int code)=0;
		virtual void   ProcessResultsUnits(void)=0;
		virtual void   RequestedOutput(int output_enum,int step,IssmDouble time)=0;
		
		virtual int    NodalValue(IssmDouble* pvalue, int index, int natureofdataenum,bool process_units)=0;
		virtual void   InputScale(int enum_type,IssmDouble scale_factor)=0;
		virtual void   GetVectorFromInputs(Vector* vector, int name_enum)=0;
		virtual void   GetVectorFromResults(Vector* vector,int id,int enum_in,int interp)=0;
		virtual void   InputArtificialNoise(int enum_type,IssmDouble min,IssmDouble max)=0;
		virtual bool   InputConvergence(IssmDouble* eps, int* enums,int num_enums,int* criterionenums,IssmDouble* criterionvalues,int num_criterionenums)=0;
		virtual void   AverageOntoPartition(Vector* partition_contributions,Vector* partition_areas,IssmDouble* vertex_response,IssmDouble* qmu_part)=0;
		virtual int*   GetHorizontalNeighboorSids(void)=0;
		virtual IssmDouble TimeAdapt()=0;
		virtual void   MigrateGroundingLine(IssmDouble* old_floating_ice,IssmDouble* sheet_ungrounding)=0;
		virtual void   PotentialSheetUngrounding(Vector* potential_sheet_ungrounding)=0;
		virtual void   PositiveDegreeDay(IssmDouble* pdds,IssmDouble* pds,IssmDouble signorm)=0;
		virtual void   SmbGradients()=0;
		virtual int    UpdatePotentialSheetUngrounding(IssmDouble* potential_sheet_ungrounding,Vector* vec_nodes_on_iceshelf,IssmDouble* nodes_on_iceshelf)=0;
		virtual void   ResetCoordinateSystem()=0;
		virtual void   SmearFunction(Vector* smearedvector,IssmDouble (*WeightFunction)(IssmDouble distance,IssmDouble radius),IssmDouble radius)=0;

		#ifdef _HAVE_RESPONSES_
		virtual void   MinVel(IssmDouble* pminvel, bool process_units)=0;
		virtual void   MaxVel(IssmDouble* pmaxvel, bool process_units)=0;
		virtual void   MinVx(IssmDouble* pminvx, bool process_units)=0;
		virtual void   MaxVx(IssmDouble* pmaxvx, bool process_units)=0;
		virtual void   MaxAbsVx(IssmDouble* pmaxabsvx, bool process_units)=0;
		virtual void   MinVy(IssmDouble* pminvy, bool process_units)=0;
		virtual void   MaxVy(IssmDouble* pmaxvy, bool process_units)=0;
		virtual void   MaxAbsVy(IssmDouble* pmaxabsvy, bool process_units)=0;
		virtual void   MinVz(IssmDouble* pminvz, bool process_units)=0;
		virtual void   MaxVz(IssmDouble* pmaxvz, bool process_units)=0;
		virtual void   MaxAbsVz(IssmDouble* pmaxabsvz, bool process_units)=0;
		virtual IssmDouble MassFlux(IssmDouble* segment,bool process_units)=0;
		virtual void   ElementResponse(IssmDouble* presponse,int response_enum,bool process_units)=0;
		virtual IssmDouble IceVolume(void)=0;
		#endif

		#ifdef _HAVE_CONTROL_
		virtual void   Gradj(Vector* gradient,int control_type,int control_index)=0;
		virtual IssmDouble ThicknessAbsMisfit(bool process_units  ,int weight_index)=0;
		virtual IssmDouble SurfaceAbsVelMisfit(bool process_units ,int weight_index)=0;
		virtual IssmDouble SurfaceRelVelMisfit(bool process_units ,int weight_index)=0;
		virtual IssmDouble SurfaceLogVelMisfit(bool process_units ,int weight_index)=0;
		virtual IssmDouble SurfaceLogVxVyMisfit(bool process_units,int weight_index)=0;
		virtual IssmDouble SurfaceAverageVelMisfit(bool process_units,int weight_index)=0;
		virtual IssmDouble ThicknessAbsGradient(bool process_units,int weight_index)=0;
		virtual IssmDouble RheologyBbarAbsGradient(bool process_units,int weight_index)=0;
		virtual IssmDouble DragCoefficientAbsGradient(bool process_units,int weight_index)=0;
		virtual void   ControlInputGetGradient(Vector* gradient,int enum_type,int control_index)=0;
		virtual void   ControlInputSetGradient(IssmDouble* gradient,int enum_type,int control_index)=0;
		virtual void   ControlInputScaleGradient(int enum_type, IssmDouble scale)=0;
		virtual void   GetVectorFromControlInputs(Vector* gradient,int control_enum,int control_index,const char* data)=0;
		virtual void   SetControlInputsFromVector(IssmDouble* vector,int control_enum,int control_index)=0;
		virtual void   InputControlUpdate(IssmDouble scalar,bool save_parameter)=0;
		#endif
};
#endif
