/*! \file Contour.c
 *  \sa Contour.h
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <string.h>
#include "./objects.h"
#include "../include/include.h"
#include "../io/io.h"

/*Contour constructors and destructors:*/
/*FUNCTION Contour::Contour() default constructor {{{*/
Contour::Contour(){
	this->id=0;
	this->nods=0;
	this->x=NULL;
	this->y=NULL;
	this->closed=false;
}
/*}}}*/
/*FUNCTION Contour::Contour(int pid, int nods, IssmDouble* x, IssmDouble* y,bool closed) {{{*/
Contour::Contour(int pid,int pnods, IssmDouble* px, IssmDouble* py,bool pclosed){
	
	this->id=pid;
	this->nods=pnods;
	this->closed=pclosed;
	if(nods){
		this->x=xNew<IssmDouble>(nods);
		xMemCpy<IssmDouble>(this->x,px,nods);
		this->y=xNew<IssmDouble>(nods);
		xMemCpy<IssmDouble>(this->y,py,nods);
	}
}
/*}}}*/
/*FUNCTION Contour::Contour() default constructor {{{*/
Contour::~Contour(){
	xDelete<IssmDouble>(this->x);
	xDelete<IssmDouble>(this->y);
}
/*}}}*/


/*Object virtual function resolutoin: */
/*FUNCTION Contour::Echo(){{{*/
void Contour::Echo(void){

	int i;

	_printLine_("Contour: " << id);
	_printLine_("   nods: " << nods);
	_printLine_("   closed: " << (closed?"true":"false"));
	if(nods){
	        _printLine_("   x,y:");
		for(i=0;i<nods;i++){
		        _printLine_(i << ": " << x[i] << "|" << y[i]);
		}
	}
}
/*}}}*/
/*FUNCTION Contour::DeepEcho(){{{*/
void Contour::DeepEcho(void){
	this->Echo();
}
/*}}}*/
/*FUNCTION Contour::Id(){{{*/
int Contour::Id(void){
	return id;
}
/*}}}*/
/*FUNCTION Contour::MyRank{{{*/
int    Contour::MyRank(void){ 
	extern int my_rank;

	return my_rank; 
}
/*}}}*/
/*FUNCTION Contour::ObjectEnum{{{*/
int Contour::ObjectEnum(void){

	return ContourEnum;

}
/*}}}*/
/*FUNCTION Contour::copy {{{*/
Object* Contour::copy() {

	return new Contour(*this); 

}
/*}}}*/
