/*!\file SpcTransient.h
 * \brief: header file for spc object
 */

#ifndef _SPCTRANSIENT_H_
#define _SPCTRANSIENT_H_

/*Headers:*/
/*{{{*/
#include "../Object.h"
class DataSet;
/*}}}*/

class SpcTransient: public Constraint{

	private: 
		int	sid; /*! id, to track it*/
		int	nodeid; /*!node id*/
		int dof; /*!component*/
		IssmDouble* values; /*different values in time*/
		IssmDouble* times; /*different time steps*/
		int nsteps; /*number of time steps*/
		int analysis_type;

	public:

		/*SpcTransient constructors, destructors:{{{*/
		SpcTransient();
		SpcTransient(int sid,int nodeid, int dof,int nsteps, IssmDouble* times, IssmDouble* values,int analysis_type);
		~SpcTransient();
		/*}}}*/
		/*Object virtual functions definitions:{{{ */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*Constraint virtual functions definitions: {{{*/
		void   ConstrainNode(Nodes* nodes,Parameters* parameters);
		bool   InAnalysis(int analysis_type);
		/*}}}*/
		/*SpcTransient management:{{{ */
		int    GetNodeId();
		int    GetDof();
		IssmDouble GetValue();
		/*}}}*/

};

#endif  /* _SPCTRANSIENT_H_ */
