/*!\file Solverx
 * \brief solver
 */

#include "./Solverx.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../io/io.h"

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

void	Solverx(Vector** puf, Matrix* Kff, Vector* pf, Vector* uf0,Vector* df, Parameters* parameters){

	/*Intermediary: */
	int analysis_type;

	/*output: */
	Vector *uf=NULL;

	/*In debugging mode, check that stiffness matrix and load vectors are not NULL (they can be empty)*/
	_assert_(Kff);
	_assert_(pf);

	#ifdef _HAVE_PETSC_
		Vec uf0_vector = NULL;
		Vec df_vector  = NULL;
		Vec uf_vector  = NULL;
		if(uf0) uf0_vector = uf0->vector;
		if(df)  df_vector  = df->vector;

		/*In serial mode, the Petsc Options database has not been initialized properly: */

		SolverxPetsc(&uf_vector,Kff->matrix,pf->vector,uf0_vector,df_vector,parameters);

		/*Create vector out of petsc vector: */
		uf=new Vector(uf_vector);

		/*Free ressources: */
		VecFree(&uf_vector);
	#else
		#ifdef _HAVE_GSL_
		SeqVec* uf_vector=NULL;

		SolverxGsl(&uf_vector,Kff->matrix,pf->vector);

		/*Create vector out of SeqVec vector: */
		uf=new Vector(uf_vector);

		/*Free ressources: */
		delete uf_vector;

		#else
			_error2_("GSL support not compiled in!");
		#endif
	#endif

	/*Assign output pointers: */
	*puf=uf;
}
