function length=GetCharacteristicLength(index,x,y,varargin)
%GETCHARACTERISTICLENGTH - compute characteristic length for a mesh
%
%   compute characteristic lengths of every element of a mesh.
%
%   Usage:
%      length  =GetCharacteristicLength(index,x,y);
%      length  =GetCharacteristicLength(index,x,y,z);
%
%   Examples:
%      length  =GetCharacteristicLength(md.elements,md.x,md.y);
%      length  =GetCharacteristicLength(md.elements,md.x,md.y,md.z);


%get number of elements and number of nodes
nels=size(index,1);
nods=numel(x);

%some checks
if nargout~=1 | (nargin~=3 & nargin~=4),
	help GetCharacteristicLength
	error('GetCharacteristicLength error message: bad usage')
end
if ((numel(y)~=nods) | (nargin==4 & numel(z)~=nods)),
	error('GetCharacteristicLength error message: x,y and z do not have the same length')
end
if max(index(:))>nods,
	error(['GetCharacteristicLength error message: index should not have values above ' num2str(nods) ])
end
if (nargin==3 & size(index,2)~=3),
	error('GetCharacteristicLength error message: index should have 3 columns for 2d meshes.')
end
if (nargin==4 & size(index,2)~=6),
	error('GetCharacteristicLength error message: index should have 6 columns for 3d meshes.')
end

%get areas or volumes.
areas=GetAreas(index,x,y,varargin{:});

%for a 2d mesh: 
if nargin==3,
	length=sqrt(2*areas);
else
	error('not supported yet');
end
