/*!\file:  ProfilingStart.cpp
 * \brief ProfilingStart.c: initialize profiling before calling a routine
 */


/*Include files: {{{*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif
#include "../../include/macros.h"
#include "../shared.h"
/*}}}*/

void ProfilingStart(double* pTime_start, double* pFlops_start){
	
	double Time_start, Flops_start;
	
	#ifdef _HAVE_PETSC_
		PetscGetTime(&Time_start);
		PetscGetFlops(&Flops_start );
	#else
		_error_("Profiling not supported under this numerical toolkit");
	#endif

	/*Assign pointers: */
	*pTime_start=Time_start;
	*pFlops_start=Flops_start;
	return;
}
