function md=LaunchQueueJobGeneric(md,executionpath,options)
%LAUNCHQUEUEJOBGENERIC - ...
%
%   Usage:
%      LaunchQueueJobGeneric(md,executionpath)

%first, check we have the binary file and the queueing script
if ~exist([ md.name '.bin'],'file'),
	error('LaunchQueueJobGeneric error message: Binary input file missing, cannot go forward');
end

if ~exist([ md.name '.queue'],'file'),
	error('LaunchQueueJobGeneric error message: queueing script issing, cannot go forward');
end

%if we are running locally, no need to call ssh to launch the job. We figure out by comparing the 
%hostname to the cluster name
[result,hostname]=system('hostname -s');hostname=hostname(1:end-1);
	
disp('uploading input file and queueing script');
if strcmpi(hostname,md.cluster),
	if md.qmu_analysis,
		system(['cp ' md.name '.bin' ' ' md.name '.queue ' md.name '.qmu.in ' ' ' executionpath]);
	else
		system(['cp ' md.name '.bin' ' ' md.name '.queue' ' ' executionpath]);
	end
else
	if md.qmu_analysis,
		system(['scp ' md.name '.bin' ' ' md.name '.queue ' md.name '.qmu.in ' ' ' md.cluster ':' executionpath]);
	else
		system(['scp ' md.name '.bin' ' ' md.name '.queue' ' ' md.cluster ':' executionpath]);
	end
end

disp('launching solution sequence on remote cluster');
%now call the queuing script to launch the job.
if strcmpi(hostname,md.cluster),
	system(['cd ' executionpath ' && source ' md.name '.queue ']);
else
	system(['ssh  ' md.cluster ' ''cd ' executionpath ' && source ' md.name '.queue ''']);
end
