"""
MARSHALL - outputs a compatible binary file from @model md, for certain solution type.

    The routine creates a compatible binary file from @model md
    This binary file will be used for parallel runs in JPL-package

    Usage:
       marshall(md)
"""

from WriteData import *

def marshall(md):
	print "marshalling file '%s.bin'." % md.miscellaneous.name

	#open file for binary writing
	try:
		fid=open(md.miscellaneous.name+'.bin','wb');
	except IOError as e:
		print "marshall error message: could not open '%s.bin' file for binary writing." % md.miscellaneous.name
		raise IOError(e)

	#First, write MaximumNumberOfEnum to make sure that the Enums are synchronized
	WriteData(fid,'enum',MaximumNumberOfEnums(),'data',true,'format','Boolean')

	#Go through all model fields: check that it is a class and call checkconsistency
	fields=vars(md)

	for field in fields.interkeys():

		#Some properties do not need to be marshalled
		if field in ['results','radaroverlay','solver','cluster','flaim','private']:
			continue

		#Check that current field is an object
		if not hasattr(getattr(md,field),'marshall'):
			raise TypeError("field '%s' is not an object." % field)

		#Marshall current object
		#print "marshalling %s ..." % field
		exec("md.%s.marshall(fid)" % field)

	#close file
	try:
		f.close(fid)
	except IOError as e:
		print "marshall error message: could not close file '%s.bin'." % md.miscellaneous.name
		raise IOError(e)

