#!/bin/bash

version=4.0.1
#version=4.2

#for versions 4.2, you need hdf5 compiled, as well as doxygen for the 
#documentation!

#Some cleanup
rm -rf src install netcdf-$version
mkdir install src

#Download from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.py "http://issm.jpl.nasa.gov/files/externalpackages/netcdf-$version.tar.gz" "netcdf-$version.tar.gz"

#Untar 
tar -zxvf  netcdf-$version.tar.gz

#Move netcdf to install directory
rm -rf src/*
mv netcdf-$version/* src/
rm -rf netcdf-$version

#Configure and compile
cd src

#version dependent: 
./configure  --prefix="$ISSM_DIR/externalpackages/netcdf/install"  

if [ -z $1 ]; then
	make
else
	make -j $1
fi
make install
