function expdisp(domainoutline,varargin)
%EXPDISP - plot the contours of a domain outline file
%
%   This routine reads in a domain outline file (Argus format) and plots all the contours 
%
%   Usage:
%      expdisp(domainoutline,varargin)
%
%   See also EXPMASTER, EXPDOC

if nargin==1,
	figurenumber=1;
	linestyle='r-';
	unitmultiplier=1;
end

if nargin==2,
	figurenumber=varargin{1};
	linestyle='r-';
	unitmultiplier=1;
end

if nargin==3,
	figurenumber=varargin{1};
	linestyle=varargin{2};
	unitmultiplier=1;
end

if nargin==4,
	figurenumber=varargin{1};
	linestyle=varargin{2};
	unitmultiplier=varargin{3};
	if isnan(unitmultiplier),
		unitmultiplier=1;
	end
end
domain=expread(domainoutline,1);

figure(figurenumber),hold on
for i=1:length(domain),
	plot(domain(i).x*unitmultiplier,domain(i).y*unitmultiplier,linestyle);
end
