function struct=expread(name,whole);
%EXPREAD - read a file exp and build a structure
%
%   This routine reads a file .exp and build a structure containing the 
%   fields x and y corresponding to the coordinates, one for the name of
%   the exp file, for the density, for the nodes, and a field closed to 
%   indicate if the domain is closed. 
%   The first argument is the .exp file to be read and the second one 
%   indicate if the last point shall be read (1 to read it, 0 not to).
%
%   Usage:
%      struct=expread(name,whole)
%  
%   Example:
%      struct=expread('domainoutline.exp',1)
%
%   See also EXPDOC, EXPWRITEASVERTICES

%some checks
if ~exist(name),
	error(['expread error message: file ' name 'not found!']);
end

try,
fid=fopen(name,'r');
i=0;
while (~feof(fid)),
   i=i+1;
   %firt line contains the name
   A=readline(fid,2);
   if length(A)>8, 
       struct(i).name=A(9:length(A));
   end

   A=readline(fid,2);
   A=readline(fid,4);

   [A,bytecount]=fscanf(fid,'%f %f',[1 2]);
   if whole==1,
       struct(i).nods=A(1);
   else
       struct(i).nods=A(1)-1;
   end
   struct(i).density=A(2);
   A=readline(fid,5);

   struct(i).x=zeros(struct(i).nods,1);
   struct(i).y=zeros(struct(i).nods,1);
   struct(i).closed=0;

   for n=1:struct(i).nods,
       [A,bytecount]=fscanf(fid,'%f %f',[1 2]);
       struct(i).x(n)=A(1);
       struct(i).y(n)=A(2);
   end
   if whole==0,
       fscanf(fid,'%f %f',[1 2]);
   end

end
catch,
end
fclose(fid);
