/*!\file:  isnan.h
 * \brief: only used for intel compiler.
 */ 

#ifndef _XISNAN_H_
#define _XISNAN_H_

#include <cmath>

template <class T> int xIsNan(const T& X) {
#ifdef _INTEL_WIN_
		return (X!=X)?1:0;
#else
		return isnan(X);
#endif
}

#ifdef _HAVE_ADOLC_
template <> int xIsNan<adouble> (const adouble& X);
#endif

#endif
