function fielddisplay(md,offset,name,comment)
%FIELDDISPLAY - display model field
%
%   Usage:
%      fielddisplay(md,offset,name,comment)

	%get field
	field=md.(name);

	%disp corresponding line as a function of field type
	parsedisplay(offset,name,field,comment);

end %function

function parsedisplay(offset,name,field,comment);

	%string
	if ischar(field),

		if length(field)>30;
			displayunit(offset,name,'not displayed',comment),
		else
			displayunit(offset,name,['''' field ''''],comment),
		end

	%numeric
	elseif isnumeric(field)

		%get size
		fieldsize=size(field);

		%double
		if max(fieldsize)==1,
			displayunit(offset,name,num2str(field),comment),
		%matrix
		else
			displayunit(offset,name,['(' num2str(fieldsize(1)) 'x' num2str(fieldsize(2)) ')'],comment),
		end

		%structure
	elseif isstruct(field),
		struct_display(field,offset),

	%cell
	elseif iscell(field),
		cell_display(offset,name,field,comment),

	else
		error('displayline error message: type not supported yet');
	end
end %function

function struct_display(structure,offset)

	structure_fields=fields(structure);

	for i=1:length(structure_fields),

		%get current field
		field=structure.(structure_fields{i});

		%recursive call if necessary
		if isstruct(field),
			disp(sprintf('%s',[offset structure_fields{i} ':']));
			struct_display(field,[offset '   ']);

		%display value
		else
			parsedisplay(offset,structure_fields{i},field,'');
		end
	end
end

function cell_display(offset,name,field,comment)

	%initialization
	string='{';

	%go through the cell and fill string
	if length(field)<5;
		for i=1:length(field),
			if ischar(field{i}),
				string=[string ''''  field{i} ''','];
			elseif (isnumeric(field{i}) & length(field{i})==1)
				string=[string num2str(field{i}) ',' ];
			else
				string='{';
				break
			end
		end
	end
	if strcmp(string,'{'),
		string=['(' num2str(size(field,1)) 'x' num2str(size(field,2)) ')'];
	else
		string=[string(1:end-1) '}'];
	end

	%call displayunit
	displayunit(offset,name,string,comment);
end

function displayunit(offset,name,caracterization,comment),

	%take care of name
	if length(name)>23,
		name=[name(1:20) '...'];
	end

	%take care of caracterization
	if (strcmp(caracterization,['''' '''']) | strcmp(caracterization,'NaN')),
		caracterization='N/A';
	end
	if length(caracterization)>15,
		caracterization=[caracterization(1:12) '...'];
	end

	%print
	if isempty(comment)
		disp(sprintf('%s%-23s: %-15s',offset,name,caracterization));
	else
		disp(sprintf('%s%-23s: %-15s -- %s',offset,name,caracterization,comment));
	end
end
