#!/bin/bash
source $ANDROID_DIR/android_variables.sh

#Some cleanup
rm -rf src install gsl-1.15
mkdir src install

#Download from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.py 'http://issm.jpl.nasa.gov/files/externalpackages/gsl-1.15.tar.gz' 'gsl-1.15.tar.gz'

#Untar 
tar -zxvf  gsl-1.15.tar.gz

#Move gsl into src directory
mv gsl-1.15/* src
rm -rf gsl-1.15

#Configure gsl
cd src

./configure \
    CC=${toolchain_path}-gcc\
    LD=${toolchain_path}-ld\
    AR=${toolchain_path}-ar\
    RANLIB=${toolchain_path}-ranlib\
    NM=${toolchain_path}-nm\
    OBJ_EXT=o\
    LIB_EXT=a\
    --host="arm-linux"\
	--prefix="$ISSM_DIR/externalpackages/gsl/install" 

#Compile gsl
if [ -z $1 ]; then
	make
else
	make -j $1
fi

make install
