#ISSM_DIR and ISSM_ARCH should have been defined already in your shell settings file (.bashrc, .cshrc, etc ...)
source $ISSM_DIR/etc/environment_variables.csh

#Do we have any command line arguments? (such as MATLAB_DIR=otherdirthandefault), source them before exporting the variables 
#to environment.

#foreach i ($@)
#eval $i
#end

#CRON utilities
setenv PATH {$PATH}:{$ISSM_DIR}/cron

#SCRIPTS utilities
setenv PATH {$PATH}:{$ISSM_DIR}/scripts

#MATLAB
setenv MATLAB_DIR {$MATLAB_DIR}
setenv PATH {$MATLAB_DIR}/bin:{$PATH}
setenv LD_LIBRARY_PATH {$LD_LIBRARY_PATH}:$MATLAB_DIR/lib

#MPI
setenv MPI_DIR {$MPI_DIR}
setenv PATH {$MPI_DIR}/bin:{$PATH}
setenv LD_LIBRARY_PATH {$LD_LIBRARY_PATH}:$MPI_DIR/lib
setenv MANPATH {$MANPATH}:$MPI_DIR/man
setenv MPIRUN_NPROCS 8

#PETSC
setenv PETSC_DIR {$PETSC_DIR}
setenv LD_LIBRARY_PATH {$LD_LIBRARY_PATH}:$PETSC_DIR/lib/{$ISSM_ARCH}

#SLEPC
setenv SLEPC_DIR {$SLEPC_DIR}
setenv LD_LIBRARY_PATH {$LD_LIBRARY_PATH}:$SLEPC_DIR/lib/{$ISSM_ARCH}


#Dakota
setenv DAKOTA_DIR {$DAKOTA_DIR}
setenv PATH {$PATH}:{$DAKOTA_DIR}/bin
setenv MANPATH {$MANPATH}:{$MPI_DIR}/man:{$DAKOTA_DIR}/docs/man:{$DAKOTA_DIR}/docs/man-ref

#Qhull
setenv QHULL_DIR {$QHULL_DIR}
setenv LD_LIBRARY_PATH {$LD_LIBRARY_PATH}:{$QHULL_DIR}/lib


#Doxygen
setenv DOXYGEN_DIR {$DOXYGEN_DIR}
setenv MANPATH {$MANPATH}:{$DOXYGEN_DIR}/man
setenv PATH {$PATH}:{$DOXYGEN_DIR}/bin

#MTOC
setenv MTOC_DIR {$MTOC_DIR}
setenv PATH {$PATH}:{$MTOC_DIR}

#MATLAB
setenv MATLAB_DIR {$MATLAB_DIR}
setenv LD_LIBRARY_PATH {$LD_LIBRARY_PATH}:{$MATLAB_DIR}/bin/glnxa64
setenv PATH {$PATH}:{$MATLAB_DIR}/bin

#TRIANGLE
setenv TRIANGLE_DIR {$TRIANGLE_DIR}

#METIS
setenv METIS_DIR {$METIS_DIR}
	
#BLAS
setenv BLAS_DIR {$BLAS_DIR}

#LAPACK
setenv LAPACK_DIR {$LAPACK_DIR}

#SCALAPACK
setenv SCALAPACK_DIR {$SCALAPACK_DIR}

#PLAPACK
setenv PLAPACK_DIR {$PLAPACK_DIR}

#BLACS
setenv BLACS_DIR {$BLACS_DIR}

#YAMS
setenv YAMS_DIR {$YAMS_DIR}
setenv PATH {$PATH}:{$YAMS_DIR}

#TEX2IM
setenv TEX2IM_DIR {$TEX2IM_DIR}
setenv PATH {$PATH}:{$TEX2IM_DIR}

#SOWING
setenv SOWING_DIR {$SOWING_DIR}
setenv PATH {$PATH}:{$SOWING_DIR}/bin
setenv LD_LIBRARY_PATH {$LD_LIBRARY_PATH}:{$SOWING_DIR}/lib
setenv MANPATH {$MANPATH}:{$SOWING_DIR}/man

#Chaco
setenv CHACO_DIR {$CHACO_DIR}
setenv PATH {$PATH}:{$CHACO_DIR}

#MeshPart
setenv MESHPART_DIR {$MESHPART_DIR}
setenv PATH {$PATH}:{$MESHPART_DIR}

#SCOTCH
setenv SCOTCH_DIR {$SCOTCH_DIR}
setenv PATH {$PATH}:{$SCOTCH_DIR}
setenv MANPATH {$MANPATH}:{$SCOTCH_DIR}/man

#AUTOCONF
setenv AUTOCONF_DIR {$AUTOCONF_DIR}
setenv PATH {$AUTOCONF_DIR}/bin:{$PATH}

#AUTOMAKE
setenv AUTOMAKE_DIR {$AUTOMAKE_DIR}
setenv PATH {$AUTOMAKE_DIR}/bin:{$PATH}

#BORLAND
setenv BORLAND_DIR {$BORLAND_DIR}
setenv PATH {$PATH}:{$BORLAND_DIR}/Bin

#SSH
setenv SSH_DIR {$SSH_DIR}
setenv PATH {$PATH}:{$SSH_DIR}

#VALGRIND
setenv VALGRIND_DIR {$VALGRIND_DIR}
setenv PATH {$PATH}:{$VALGRIND_DIR}

#MERCURIAL
#setenv PYTHONPATH {$PYTHONPATH}:{$MERCURIAL_DIR}/mercurial/pure/
setenv PYTHONPATH {$MERCURIAL_DIR}/mercurial/pure/
setenv PATH {$PATH}:{$MERCURIAL_DIR}

#GSL
setenv GSL_DIR {$GSL_DIR}
setenv LD_LIBRARY_PATH {$LD_LIBRARY_PATH}:{$GSL_DIR}/lib
