/*!\file BoolExternalResult.c
 * \brief: implementation of the BoolExternalResult object
 */

/*header files: */
/*{{{*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*BoolExternalResult constructors and destructor*/
/*FUNCTION BoolExternalResult::BoolExternalResult(){{{*/
BoolExternalResult::BoolExternalResult(){
	return;
}
/*}}}*/
/*FUNCTION BoolExternalResult::BoolExternalResult(int enum_type,bool value){{{*/
BoolExternalResult::BoolExternalResult(int in_id, int in_enum_type,bool in_value,int in_step, IssmDouble in_time){

	id=in_id;
	enum_type=in_enum_type;
	value=in_value;
	step=in_step;
	time=in_time;
}
/*}}}*/
/*FUNCTION BoolExternalResult::~BoolExternalResult(){{{*/
BoolExternalResult::~BoolExternalResult(){
	return;
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION BoolExternalResult::Echo {{{*/
void BoolExternalResult::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION BoolExternalResult::DeepEcho{{{*/
void BoolExternalResult::DeepEcho(void){

	_printLine_("BoolExternalResult:");
	_printLine_("   id: " << this->id);
	_printLine_("   enum:  " << this->enum_type << " (" << EnumToStringx(this->enum_type) << ")");
	_printLine_("   value: " <<(this->value?"true":"false"));
	_printLine_("   step: " << this->step);
	_printLine_("   time: " << this->time);
}
/*}}}*/
/*FUNCTION BoolExternalResult::Id{{{*/
int    BoolExternalResult::Id(void){ return -1; }
/*}}}*/
/*FUNCTION BoolExternalResult::MyRank{{{*/
int    BoolExternalResult::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
/*FUNCTION BoolExternalResult::ObjectEnum{{{*/
int BoolExternalResult::ObjectEnum(void){

	return BoolExternalResultEnum;

}
/*}}}*/
/*FUNCTION BoolExternalResult::copy{{{*/
Object* BoolExternalResult::copy() {
	
	return new BoolExternalResult(this->id,this->enum_type,this->value,this->step,this->time);

}
/*}}}*/

/*BoolExternalResult management: */
/*FUNCTION BoolExternalResult::WriteData{{{*/
void   BoolExternalResult::WriteData(FILE* fid,bool io_gather){

	int     length;
	int     type;
	int     size;
	IssmPDouble  passiveDouble;
	extern  int my_rank;
	char*   name = NULL;

	/*return if now on cpu 0: */
	if(my_rank)return;

	/*First write enum: */
	EnumToStringx(&name,this->enum_type);
	length=(strlen(name)+1)*sizeof(char);
	fwrite(&length,sizeof(int),1,fid);
	fwrite(name,length,1,fid);
	xDelete<char>(name);

	/*Now write time and step: */
	passiveDouble=reCast<IssmPDouble>(time);
	fwrite(&passiveDouble,sizeof(IssmPDouble),1,fid);
	fwrite(&step,sizeof(int),1,fid);

	/*writing a IssmDouble, type is 1, size is 1: */
	type=1;
	size=1;
	fwrite(&type,sizeof(int),1,fid);
	fwrite(&size,sizeof(int),1,fid);
        /*Now write bool, after casting it: */
        passiveDouble=reCast<IssmPDouble>(this->value);
        fwrite(&passiveDouble,size*sizeof(IssmPDouble),1,fid);

}
/*}}}*/
/*FUNCTION BoolExternalResult::GetResultName{{{*/
void BoolExternalResult::GetResultName(char** pname){
	EnumToStringx(pname,this->enum_type);
}
/*}}}*/
/*FUNCTION BoolExternalResult::GetStep{{{*/
int BoolExternalResult::GetStep(void){

	return this->step;
}
/*}}}*/
