/*
 * recast.h
 *
 *  Created on: Jun 26, 2012
 *      Author: utke
 */

#ifndef _RECAST_H_
#define _RECAST_H_

#ifndef _HAVE_ADOLC_

template<class To, class From>
To reCast(const From& from) {
    return (To)from;
}

#else

template<class To, class From>
struct ForPartialSpecialization {
    static  To reCast(const From& from ) { return (To) from;}
};

template<class To, class From>
To reCast(const From& from) {
    return ForPartialSpecialization<To,From>::reCast(from);
}
/**
 * partial specialization
 */
template<class To>
struct ForPartialSpecialization<To,adouble> {
    static  To reCast(const adouble& from ) { return (To) (from.getValue());}
};

#endif

#endif
