function display(a)
%DISPLAY - display the fields of a model
%
%   echo function for 'model' class
	
disp(sprintf('\n%s = \n',inputname(1)));

%name
disp(sprintf('   Name:'));
if isempty(a.name),
	disp(sprintf('      N/A'));
else
	disp(sprintf('      %s',a.name));
end

%notes: a.notes is a cell array of strings
disp(sprintf('   Notes:'));
if isempty(a.notes),
	disp(sprintf('      N/A'));
else
	if iscell(a.notes),
		strings=a.notes;
		for i=1:length(strings),
			string=char(strings(i));
			if i==1,
				disp(sprintf('      %s',string));
			else
				disp(sprintf('      %s',string));
			end
		end
	elseif ischar(a.notes),
		disp(sprintf('      %s',a.notes));
	else
		disp('display error message: ''notes'' for model is neither a cell array of string, nor a string. Cannot display.');
	end
end

%repository
if ~isempty(a.repository),
	disp(sprintf('   Repository: %s',a.repository));
end

%diverse
disp(sprintf('   Mesh: %s',a.repository));
disp(sprintf('%s%s%s','      Mesh: type ''',inputname(1),'.mesh'' to display'));
disp(sprintf('   Parameters: %s',a.repository));
disp(sprintf('%s%s%s','      Boundary conditions: type ''',inputname(1),'.bc'' to display'));
disp(sprintf('%s%s%s','      Observations: type ''',inputname(1),'.obs'' to display'));
disp(sprintf('%s%s%s','      Materials: type ''',inputname(1),'.mat'' to display'));
disp(sprintf('%s%s%s','      Parameters: type ''',inputname(1),'.par'' to display'));
disp(sprintf('%s%s%s','      Results: type ''',inputname(1),'.res'' to display'));
disp(sprintf('%s%s%s','      ExpPar: type ''',inputname(1),'.exppar'' to display'));
disp(sprintf('   Solution parameters: %s',a.repository));
disp(sprintf('%s%s%s','      Qmu: type ''',inputname(1),'.qmu'' to display'));
disp(sprintf('%s%s%s','      Diagnostic solution parameters: type ''',inputname(1),'.diagnostic'' to display'));
disp(sprintf('%s%s%s','      Thermal solution parameters: type ''',inputname(1),'.thermal'' to display'));
disp(sprintf('%s%s%s','      Prognostic solution parameters: type ''',inputname(1),'.prognostic'' to display'));
disp(sprintf('%s%s%s','      Transient solution parameters: type ''',inputname(1),'.transient'' to display'));
disp(sprintf('%s%s%s','      Control solution parameters: type ''',inputname(1),'.control'' to display'));
disp(sprintf('%s%s%s','      Mesh2grid solution parameters: type ''',inputname(1),'.mesh2grid'' to display'));
if(a.numrifts)disp(sprintf('      rifts: %i',a.numrifts));end

