/*!\file BoolInput.c
 * \brief: implementation of the BoolInput object
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"

/*BoolInput constructors and destructor*/
/*FUNCTION BoolInput::BoolInput(){{{*/
BoolInput::BoolInput(){
	return;
}
/*}}}*/
/*FUNCTION BoolInput::BoolInput(IssmDouble* values){{{*/
BoolInput::BoolInput(int in_enum_type,IssmBool in_value){

	enum_type=in_enum_type;
	value=in_value;
}
/*}}}*/
/*FUNCTION BoolInput::~BoolInput(){{{*/
BoolInput::~BoolInput(){
	return;
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION BoolInput::Echo {{{*/
void BoolInput::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION BoolInput::DeepEcho{{{*/
void BoolInput::DeepEcho(void){

	_printLine_("BoolInput:");
	_printLine_("   enum: " << this->enum_type << " (" << EnumToStringx(this->enum_type) << ")");
	_printLine_("   value: " <<(value?"true":"false"));
}
/*}}}*/
/*FUNCTION BoolInput::Id{{{*/
int    BoolInput::Id(void){ return -1; }
/*}}}*/
/*FUNCTION BoolInput::MyRank{{{*/
int    BoolInput::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
/*FUNCTION BoolInput::ObjectEnum{{{*/
int BoolInput::ObjectEnum(void){

	return BoolInputEnum;

}
/*}}}*/
/*FUNCTION BoolInput::copy{{{*/
Object* BoolInput::copy() {
	
	return new BoolInput(this->enum_type,this->value);

}
/*}}}*/
	
/*BoolInput management*/
/*FUNCTION BoolInput::InstanceEnum{{{*/
int BoolInput::InstanceEnum(void){

	return this->enum_type;

}
/*}}}*/
/*FUNCTION BoolInput::SpawnTriaInput{{{*/
Input* BoolInput::SpawnTriaInput(int* indices){

		/*output*/
		BoolInput* outinput=new BoolInput();

		/*only copy current value*/
		outinput->enum_type=this->enum_type;
		outinput->value=this->value;

		/*Assign output*/
		return outinput;

}
/*}}}*/
/*FUNCTION BoolInput::SpawnResult{{{*/
ElementResult* BoolInput::SpawnResult(int step, IssmDouble time){
	
	return new BoolElementResult(this->enum_type,this->value,step,time);

}
/*}}}*/

/*Object functions*/
/*FUNCTION BoolInput::GetInputValue(bool* pvalue) {{{*/
void BoolInput::GetInputValue(bool* pvalue){
	*pvalue=value;
}
/*}}}*/
/*FUNCTION BoolInput::GetInputValue(int* pvalue){{{*/
void BoolInput::GetInputValue(int* pvalue){_error2_("not supported yet!");}
/*}}}*/
/*FUNCTION BoolInput::GetInputValue(IssmDouble* pvalue){{{*/
void BoolInput::GetInputValue(IssmDouble* pvalue){_error2_("not supported yet!");}
/*}}}*/
/*FUNCTION BoolInput::GetInputValue(IssmDouble* pvalue,GaussTria* gauss){{{*/
void BoolInput::GetInputValue(IssmDouble* pvalue,GaussTria* gauss){_error2_("not supported yet!");}
/*}}}*/
/*FUNCTION BoolInput::GetInputValue(IssmDouble* pvalue,GaussPenta* gauss){{{*/
void BoolInput::GetInputValue(IssmDouble* pvalue,GaussPenta* gauss){_error2_("not supported yet!");}
/*}}}*/
/*FUNCTION BoolInput::GetInputDerivativeValue(IssmDouble* derivativevalues, IssmPDouble* xyz_list, GaussTria* gauss){{{*/
void BoolInput::GetInputDerivativeValue(IssmDouble* derivativevalues, IssmPDouble* xyz_list, GaussTria* gauss){_error2_("not supported yet!");}
/*}}}*/
/*FUNCTION BoolInput::GetInputDerivativeValue(IssmDouble* derivativevalues, IssmPDouble* xyz_list, GaussPenta* gauss){{{*/
void BoolInput::GetInputDerivativeValue(IssmDouble* derivativevalues, IssmPDouble* xyz_list, GaussPenta* gauss){_error2_("not supported yet!");}
/*}}}*/
/*FUNCTION BoolInput::ChangeEnum{{{*/
void BoolInput::ChangeEnum(int newenumtype){
	this->enum_type=newenumtype;
}
/*}}}*/
/*FUNCTION BoolInput::SquareMin{{{*/
void BoolInput::SquareMin(IssmDouble* psquaremin, bool process_units,Parameters* parameters){
	/*square of a bool is the bool itself: */
	*psquaremin=value;
}
/*}}}*/
/*FUNCTION BoolInput::Scale{{{*/
void BoolInput::Scale(IssmDouble scale_factor){
	/*a bool cannot be scaled: */
}
/*}}}*/
/*FUNCTION BoolInput::AXPY{{{*/
void BoolInput::AXPY(Input* xinput,IssmDouble scalar){

	BoolInput*  xboolinput=NULL;

	/*xinput is of the same type, so cast it: */
	xboolinput=(BoolInput*)xinput;

	/*Carry out the AXPY operation depending on type:*/
	switch(xinput->ObjectEnum()){

		case BoolInputEnum:
			this->value=(bool)(this->value+scalar*xboolinput->value);
			return;

		default:
			_error2_("not implemented yet");
	}

}
/*}}}*/
/*FUNCTION BoolInput::Constrain{{{*/
void BoolInput::Constrain(IssmDouble cm_min, IssmDouble cm_max){

	if(!xIsNan<IssmDouble>(cm_min)) if (this->value<cm_min)this->value=cm_min;
	if(!xIsNan<IssmDouble>(cm_max)) if (this->value>cm_max)this->value=cm_max;

}
/*}}}*/
/*FUNCTION BoolInput::Extrude{{{*/
void BoolInput::Extrude(void){

	/*do nothing*/
	return;
}
/*}}}*/
/*FUNCTION BoolInput::GetVectorFromInputs{{{*/
void BoolInput::GetVectorFromInputs(Vector* vector,int* doflist){

	_error2_("not supporte yet!");

}
/*}}}*/
/*FUNCTION BoolInput::GetValuesPtr{{{*/
void BoolInput::GetValuesPtr(IssmDouble** pvalues,int* pnum_values){

	_error2_("not supported yet!");

}
/*}}}*/
/*FUNCTION BoolInput::Configure{{{*/
void BoolInput::Configure(Parameters* parameters){
	/*do nothing: */
}
/*}}}*/
