function displaythermal(md)
%DISPLAYTHERMAL - display solution parameters applied to thermal model
%
%   To avoid clobbering display.m with every field from model md, 
%   we create this routine that displays the solution parameters
%   from model md, only if requested.
%
%   Usage:
%      displaythermal(md)

disp(sprintf('   Thermal solution parameters:'));

disp(sprintf('\n      boundary conditions:'));
fielddisplay(md,'         ','gridondirichlet_thermal','grid on dirichlet flags list');
fielddisplay(md,'         ','dirichletvalues_thermal','values of the dirichlet [m]');
fielddisplay(md,'         ','melting','melting rate [m/a]');

disp(sprintf('\n      transient:'));
fielddisplay(md,'         ','dt','time step [yr]');
fielddisplay(md,'         ','ndt','time span [yr]');
