function result = subsref(md,index)
%SUBSREF - handle indexed references to model objects
%
%   the first argument is the object and the second one a structure array
%   Usage:
%      result = subsref(md,index)
% 
%   See also SUBSASGN

if length(index)==1,
	index1=index(1);
	if(strcmp(index1.subs,'res')), displayresults(md);return; end
	if(strcmp(index1.subs,'parallel')), displayparallel(md);return; end
	if(strcmp(index1.subs,'diagnostic')), displaydiagnostic(md);return; end
	if(strcmp(index1.subs,'prognostic')), displayprognostic(md);return; end
	if(strcmp(index1.subs,'thermal')), displaythermal(md);return; end
	if(strcmp(index1.subs,'transient')), displaytransient(md);return; end
	if(strcmp(index1.subs,'control')), displaycontrol(md);return; end
	if(strcmp(index1.subs,'mesh2grid')), displaymesh2grid(md);return; end
	if(strcmp(index1.subs,'bc')), displaybc(md);return; end
	if(strcmp(index1.subs,'mesh')), displaymesh(md);return; end
	if(strcmp(index1.subs,'par')), displayparameters(md);return; end
	if(strcmp(index1.subs,'exppar')), displayexppar(md);return; end
	if(strcmp(index1.subs,'obs')), displayobservations(md);return; end
	if(strcmp(index1.subs,'mat')), displaymaterials(md);return; end
	if(strcmp(index1.subs,'qmu')), displayqmu(md);return; end

	if ~isempty(md.repository),
		%load variable needed, if necessary
		if exist(['.' md.repository '.' index1.subs],'file'),
			structure=load(['.' md.repository '.' index1.subs],'-mat');
			eval(['result=structure.' index1.subs ';']);
		else
			%the file does not exist, just return built in value
			result=builtin('subsref',md,index);
		end
	else
		%return built in value
		result=builtin('subsref',md,index);
	end
else
	if ~isempty(md.repository),
		if exist(['.' md.repository '.' index(1).subs],'file'),
			%load variable needed
			variable=load(['.' md.repository '.' index(1).subs],'-mat');
		
			%use temporary structure.
			result=builtin('subsref',variable,index);
		else
			result=builtin('subsref',md,index);
		end
	else
		result=builtin('subsref',md,index);
	end
end
