/*!\file UpdateConstraintsx
 * \brief: update constraints and nodes (especially degree of freedom distribution) at time t.
 */

#include "./UpdateConstraintsx.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../modules/modules.h"
#include "../../io/io.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void UpdateConstraintsx(Nodes* nodes,Constraints* constraints,Parameters* parameters){

	IssmDouble time;
	int    analysis_type;

	/*retrieve parameters: */
	parameters->FindParam(&analysis_type,AnalysisTypeEnum);
	parameters->FindParam(&time,TimeEnum);

	/*start module: */
	if(VerboseModule()) _pprintLine_("   Updating constraints for time: " << time);
	
	/*First, update dof constraints in nodes, using constraints: */
	SpcNodesx(nodes,constraints,parameters,analysis_type); 

	/*Now, update degrees of freedoms: */
	NodesDofx(nodes,parameters,analysis_type);

}
