function displayresults(md)
%DISPLAYRESULTS - display results
%
%   To avoid clobbering display.m with every field from model md, 
%   we create this routine that displays results from model md, 
%   only if requested.
%
%   Usage:
%      displayresults(md)

disp(sprintf('   Results:'));

%call struct_display recursively on md.results
struct_display(md.results,'      ');

%display output parameters
disp(sprintf('\n      output parameters:'));
if ~isstruct(md.stress), disp(sprintf('         stress: N/A')); 
else 
	disp(sprintf('         stress [Pa]:'));
	struct_display(md.stress,'         ');
end
if ~isstruct(md.deviatoricstress), disp(sprintf('         deviatoricstress: N/A')); 
else 
	disp(sprintf('         deviatoricstress [Pa]:'));
	struct_display(md.deviatoricstress,'         ');
end
if ~isstruct(md.strainrate), disp(sprintf('         strainrate: N/A')); 
else 
	disp(sprintf('         strainrate [1/a]:'));
	struct_display(md.strainrate,'         ');
end
end

function struct_display(structure,offset)
	structure_fields=fields(structure);
	for i=1:length(structure_fields),
		%recursive call if necessary
		field=eval(['structure.' structure_fields{i}]);
		if isstruct(field),
			disp(sprintf('\n%s',[offset structure_fields{i} ':']));
			struct_display(field,[offset '   ']);
		else
			disp(sprintf('%s',[offset structure_fields{i} ': (' num2str(size(field,1))  ')' ]));
		end
	end
end
