function displayparameters(md)
%DISPLAYPARAMETERS - display parameters
%
%   To avoid clobbering display.m with every field from model md, 
%   we create this routine that displays parameters from model md, 
%   only if requested.
%
%   Usage:
%      displayparameters(md)

disp(sprintf('   Parameters:'));

disp(sprintf('\n      geometry:'));
if isempty(md.surface), disp(sprintf('         surface: N/A')); else disp(sprintf('         surface [m]: (%i)',length(md.surface))); end
if isempty(md.thickness), disp(sprintf('         thickness: N/A')); else disp(sprintf('         thickness [m]: (%i)',length(md.thickness))); end
if isempty(md.bed), disp(sprintf('         bed: N/A')); else disp(sprintf('         bed [m]: (%i)',length(md.bed))); end
if isempty(md.firn_layer), disp(sprintf('         firn_layer: N/A')); else disp(sprintf('         firn_layer [m]: (%i)',length(md.firn_layer))); end
if strcmpi(md.type,'3d'), disp(sprintf('         elementonbed: (%i)',length(md.elementonbed))); end
if strcmpi(md.type,'3d'), disp(sprintf('         elementonsurface: (%i)',length(md.elementonsurface))); end
if strcmpi(md.type,'3d'), disp(sprintf('         gridonbed: (%i)',length(md.gridonbed))); end
if strcmpi(md.type,'3d'), disp(sprintf('         gridonsurface: (%i)',length(md.gridonsurface))); end

disp(sprintf('\n      physical parameters:'));
disp(sprintf('         g: %g [m/s^2]',md.g));

disp(sprintf('\n      Friction parameters (Sigma= drag^2 * Neff ^r * u ^s, with Neff=rho_ice*g*thickness+rho_ice*g*bed, r=q/p and s=1/p)'));
disp(sprintf('         drag_type: %i (0: none, 1:plastic, 2:viscous):',md.drag_type));
if isempty(md.drag), disp(sprintf('         drag: N/A')); else disp(sprintf('         drag: (%i)',length(md.drag))); end
disp(sprintf('         drag_type: %i (0: none, 1:plastic, 2:viscous):',md.drag_type));
if isempty(md.p), disp(sprintf('         p: N/A')); else disp(sprintf('         p: (%i)',length(md.p))); end
if isempty(md.q), disp(sprintf('         q: N/A')); else disp(sprintf('         q: (%i)',length(md.q))); end
