function displaymesh(md)
%DISPLAYMESH - display mesh information
%
%   To avoid clobbering display.m with every field from model md, 
%   we create this routine that displays mesh information from model md, 
%   only if requested.
%
%   Usage:
%      displaymesh(md)

disp(sprintf('   Mesh:')); 

if strcmpi(md.type,'3d'),

	disp(sprintf('\n      Elements and nodes of the original 2d mesh:'));
	disp(sprintf('         numberofelements2d: %i (number of elements)',md.numberofelements2d));
	disp(sprintf('         numberofgrids2d: %i (number of nodes)',md.numberofgrids2d)); 
	disp(sprintf('         elements2d: (%i-%i) (index into (x,y,z), coordinates of the grids)',md.numberofelements2d,size(md.elements2d,2))); 
	disp(sprintf('         elements_type2d: (%i) (element types, according to number of grids)',md.numberofelements2d));
	disp(sprintf('         x2d: (%i) (node x coordinates)',length(md.x2d)));
	disp(sprintf('         y2d: (%i) (node y coordinates)',length(md.y2d)));
	disp(sprintf('         z2d: (%i) (node z coordinates)',length(md.z2d)));

	disp(sprintf('\n      Elements and nodes of the extruded 3d mesh:'));
else

	disp(sprintf('\n      Elements and nodes:'));
end

disp(sprintf('         numberofelements: %i (number of elements)',md.numberofelements));
disp(sprintf('         numberofgrids: %i (number of nodes)',md.numberofgrids)); 
if ~isnan(md.dof), disp(sprintf('      dof: %i (maximum number of dofs solved)',md.dof)); end
disp(sprintf('         elements: (%i-%i) (index into (x,y,z), coordinates of the grids)',md.numberofelements,size(md.elements,2))); 
disp(sprintf('         elements_type: (%i) (element types, according to number of grids)',md.numberofelements));
disp(sprintf('         x: (%i) (node x coordinates)',length(md.x)));
disp(sprintf('         y: (%i) (node y coordinates)',length(md.y)));
disp(sprintf('         z: (%i) (node z coordinates)',length(md.z)));
disp(sprintf('         numlayers: %i (number of extrusion layers)',md.numlayers));

disp(sprintf('\n      Properties:'));
disp(sprintf('         type: %s',md.type));
disp(sprintf('         Penalties: (%i-%i))',size(md.penalties,1),size(md.penalties,2)));
disp(sprintf('         gridonbed: (%i) (lower nodes flags list)',length(md.gridonbed)));
disp(sprintf('         gridonsurface: (%i) (upper nodes flags list)',length(md.gridonsurface)));
disp(sprintf('         elementonbed: (%i) (lower elements flags list)',length(md.elementonbed)));
disp(sprintf('         elementonsurface: (%i) (upper elements flags list)',length(md.elementonsurface)));
