function displayobservations(md)
%DISPLAYOBSERVATIONS - display observations information
%
%   To avoid clobbering display.m with every field from model md, 
%   we create this routine that displays observations information from model md, 
%   only if requested.
%
%   Usage:
%      displayobservations(md)

disp(sprintf('   Observations:\n'));

disp(sprintf('      vx_obs [m/a]: (%i)',length(md.vx_obs)));
disp(sprintf('      vy_obs [m/a]: (%i)',length(md.vy_obs)));
disp(sprintf('      vel_obs [m/a]: (%i)',length(md.vel_obs)));
disp(sprintf('      accumulation [m/a]: (%i)',length(md.accumulation)));
disp(sprintf('      observed_temperature [K]: (%i)',length(md.observed_temperature)));
disp(sprintf('      geothermalflux [W/m^2]: (%i)',length(md.geothermalflux)));
