/*\file TriaSearch.c
 *\brief: TriaSearch module. See TriaSearchx for more details.
 */
#include "./TriaSearch.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	int i;

	/*input: */
	double* index=NULL;
	int     nel;
	int     dummy;

	double* x=NULL;
	double* y=NULL;
	int     nods;

	double* x0=NULL;
	double* y0=NULL;
	int     numberofnodes;

	/* output: */
	double*  tria=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&TriaSearchUsage);

	/*Input datasets: */
	FetchData(&index,&nel,&dummy,INDEXHANDLE);
	FetchData(&x,&nods,XHANDLE);
	FetchData(&y,&nods,YHANDLE);
	FetchData(&x0,&numberofnodes,X0HANDLE);
	FetchData(&y0,&numberofnodes,Y0HANDLE);

	/* Echo: {{{1*/
	//printf("(x0,y0)=(%g,%g)\n",x0,y0);
	/*}}}*/

	/* Run core computations: */
	TriaSearchx(&tria,index,nel,x,y,nods,x0,y0,numberofnodes);

	/* c to matlab: */
	for(i=0;i<numberofnodes;i++)tria[i]++;

	/*Write data: */
	WriteData(TRIA,tria,numberofnodes);

	/*end module: */
	MODULEEND();
}

void TriaSearchUsage(void)
{
	if(true) _pprintLine_("TriaSearch- find triangle holding a point (x0,y0) in a mesh");
	if(true) _pprintLine_("");
	if(true) _pprintLine_("   Usage:");
	if(true) _pprintLine_("         tria=TriaSearch(index,x,y,x0,y0);");
	if(true) _pprintLine_("      index,x,y: mesh triangulatrion");
	if(true) _pprintLine_("      x0,y0: coordinates of the point for which we are trying to find a triangle");
	if(true) _pprintLine_("      x0,y0 can be an array of points");
	if(true) _pprintLine_("");
}
