/*\file StringToEnum.c
 *\brief:convert enum (int) to string
 */

#include "./StringToEnum.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	char    *name    = NULL;
	int      enum_out;

	/*checks on arguments on the matlab side: */
	if(nrhs!=NRHS){
		StringToEnumUsage(); _error2_("usage. See above");
	}

	/*Fetch inputs: */
	FetchData(&name,NAME);

	/*Run core function: */
	enum_out=StringToEnumx(name);

	/* output: */
	WriteData(ENUMOUT,enum_out);
}

void StringToEnumUsage(void)
{
	if(true) _pprintLine_("");
	if(true) _pprintLine_("   usage: " << __FUNCT__ << "enum = StringToEnum(string);");
	if(true) _pprintLine_("");
}
