/*\file InterpFromMeshToMesh2d.c
 *\brief: bamg module.
 */
#include "./InterpFromMeshToMesh2d.h"


WRAPPER(InterpFromMeshToMesh2d){

	/*input: */
	double* index=NULL;
	int     index_cols;
	double* x_data=NULL;
	int     x_data_rows;
	double* y_data=NULL;
	int     y_data_rows;
	double* data=NULL; 
	int     data_rows;
	int     data_cols;
	double* x_interp=NULL;
	int     x_interp_rows;
	double* y_interp=NULL;
	int     y_interp_rows;
	char*   contourname=NULL;
	double* default_values=NULL;
	int     num_default_values=0;
	DataSet *contours = NULL;

	/*Intermediary*/
	int nels_data;

	/* output: */
	double* data_interp=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on output arguments on the matlab side: */
	#ifdef _HAVE_MATLAB_MODULES_
	if(nlhs!=NLHS){
		InterpFromMeshToMesh2dUsage();
		_error2_("InterpFromMeshToMesh2dUsage usage error");
	}
	#endif
	/*check on input arguments: */
	if((nrhs!=6) & (nrhs!=8)){
		InterpFromMeshToMesh2dUsage();
		_error2_("InterpFromMeshToMesh2dUsage usage error");
	}

	/*Input datasets: */
	FetchData(&index,&nels_data,&index_cols,INDEX);
	FetchData(&x_data,&x_data_rows,NULL,X);
	FetchData(&y_data,&y_data_rows,NULL,Y);
	FetchData(&data,&data_rows,&data_cols,DATA);
	FetchData(&x_interp,&x_interp_rows,XINTERP);
	FetchData(&y_interp,&y_interp_rows,YINTERP);

	/*Figure out contours and default values: */
	if(nrhs==8){
		FetchData(&default_values,&num_default_values,DEFAULT);
		FetchData(&contourname,CONTOURNAME);
		contours=DomainOutlineRead(contourname);
	}
	else{
		num_default_values=0;
		default_values=NULL;
		contours=new DataSet();
	}


	/*some checks*/
	if (x_data_rows!=y_data_rows){
		_error2_("vectors x and y should have the same length!");
	}
	if (x_interp_rows!=y_interp_rows){
		_error2_("vectors x_interp and y_interp should have the same length!");
	}
	if (index_cols!=3){
		_error2_("index should have 3 columns (input provided has " << index_cols << " columns)");
	}

	/* Run core computations: */
	InterpFromMeshToMesh2dx(&data_interp,index,x_data,y_data,x_data_rows,nels_data,data,data_rows,data_cols,x_interp,y_interp,x_interp_rows,default_values,num_default_values,contours);

	/*Write data: */
	WriteData(DATAINTERP,data_interp,x_interp_rows,data_cols);

	/*end module: */
	MODULEEND();
}

void InterpFromMeshToMesh2dUsage(void)//{{{1

{
	if(true) _pprintLine_("INTERFROMMESHTOMESH2D - interpolation from a 2d triangular mesh onto a list of point");
	if(true) _pprintLine_("");
	if(true) _pprintLine_("   This function is a multi-threaded mex file that interpolates a field");
	if(true) _pprintLine_("   defined on a triangular mesh onto a list of point");
	if(true) _pprintLine_("");
	if(true) _pprintLine_("   Usage:");
	if(true) _pprintLine_("         data_interp=InterpFromMeshToMesh2d(index,x,y,data,x_interp,y_interp);");
	if(true) _pprintLine_("      or data_interp=InterpFromMeshToMesh2d(index,x,y,data,x_interp,y_interp,default_value,contourname);");
	if(true) _pprintLine_("");
	if(true) _pprintLine_("      index: index of the mesh where data is defined");
	if(true) _pprintLine_("      x,y: coordinates of the nodes where data is defined");
	if(true) _pprintLine_("      data: matrix holding the data to be interpolated onto the mesh. (one column per field)");
	if(true) _pprintLine_("      x_interp,y_interp: coordinates of the points onto which we interpolate.");
	if(true) _pprintLine_("      if default_value and contourname not specified: linear interpolation will happen on all x_interp,y_interp.");
	if(true) _pprintLine_("      if (default_value,contourname) specified: linear interpolation will happen on all x_interp,y_interp inside the contour, default value will be adopted on the rest of the mesh.");
	if(true) _pprintLine_("      note that default_value is either a scalar, or a vector of size  length(x_interp)");
	if(true) _pprintLine_("      data_interp: vector of mesh interpolated data.");
	if(true) _pprintLine_("");
	if(true) _pprintLine_("   Example:");
	if(true) _pprintLine_("      load('temperature.mat');");
	if(true) _pprintLine_("      md.initialization.temperature=InterpFromMeshToMesh2d(index,x,y,temperature,md.mesh.x,md.mesh.y);");
	if(true) _pprintLine_("      md.initialization.temperature=InterpFromMeshToMesh2d(index,x,y,temperature,md.mesh.x,md.mesh.y,253,'Contour.exp');");
	if(true) _pprintLine_("");
}
//}}}
