/*\file InterpFromMeshToGrid.c
 *\brief: compute diff between observed and modeled velocity
 */

#include "./InterpFromMeshToGrid.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	double* index=NULL;
	int     nel;
	double* x=NULL;
	int     nods;
	double* y=NULL;
	double* meshdata=NULL;
	int     meshdata_length;
	double  xmin;
	double  ymax;
	double  xposting;
	double  yposting;
	int     nlines,ncols;
	double  default_value;

	/* output datasets: */
	double* griddata=NULL;
	double* x_m=NULL;
	double* y_m=NULL;


	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&InterpFromMeshToGridUsage);

	/*Input datasets: */
	FetchData(&index,&nel,NULL,INDEX);
	FetchData(&x,&nods,NULL,X);
	FetchData(&y,NULL,NULL,Y);
	FetchData(&meshdata,&meshdata_length,NULL,MESHDATA);
	FetchData(&xmin,XMIN);
	FetchData(&ymax,YMAX);
	FetchData(&xposting,XPOSTING);
	FetchData(&yposting,YPOSTING);
	FetchData(&nlines,NLINES);
	FetchData(&ncols,NCOLS);
	FetchData(&default_value,DEFAULTVALUE);

	/*Call core of computation: */
	InterpFromMeshToGridx(&x_m,&y_m,&griddata,index,x,y,nods,nel,meshdata,meshdata_length,xmin,ymax,xposting,yposting,nlines,ncols,default_value);

	/*Write results: */
	WriteData(XM,x_m,ncols);
	WriteData(YM,y_m,nlines);
	WriteData(GRIDDATA,griddata,nlines,ncols);

	/*Free ressources: */
	//let matlab do this.
	
	/*end module: */
	MODULEEND();
}

void InterpFromMeshToGridUsage(void)
{
	if(true) _pprintLine_("INTERPFROMMESHTOGRID - interpolation of a data defined on a mesh onto a grid");
	if(true) _pprintLine_("");
	if(true) _pprintLine_("   This function is a multi-threaded mex file that interpolates a field");
	if(true) _pprintLine_("   defined on a triangular mesh onto a regular grid");
	if(true) _pprintLine_("");
	if(true) _pprintLine_("   Usage:");
	if(true) _pprintLine_("      [x_m,y_m,griddata]=InterpFromMeshToGrid(index,x,y,data,xmin,ymax,xposting,yposting,nlines,ncols,default_value)");
	if(true) _pprintLine_("");
	if(true) _pprintLine_("      index,x,y: delaunay triangulation defining the mesh.");
	if(true) _pprintLine_("      meshdata: vertex values of data to be interpolated.");
	if(true) _pprintLine_("      xmin,ymax,posting,nlines,ncols: parameters that define the grid");
	if(true) _pprintLine_("      default_value: value of points located out of the mesh.");
	if(true) _pprintLine_("");
}
