/*\file EnumToString.c
 *\brief:convert enum (int) to string
 */

#include "./EnumToString.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	char    *name    = NULL;
	int      enum_in;

	/*checks on arguments on the matlab side: */
	if(nrhs!=NRHS){
		EnumToStringUsage(); _error2_("usage. See above");
	}

	/*Fetch inputs: */
	FetchData(&enum_in,ENUMIN);

	/*Run core function: */
	EnumToStringx(&name,enum_in);

	/* output: */
	WriteData(NAME,name);
}

void EnumToStringUsage(void)
{
	if(true) _pprintLine_("");
	if(true) _pprintLine_("   usage: " << __FUNCT__ << "string = EnumToString(enum);");
	if(true) _pprintLine_("");
}
