/*!\file: hydrology_core_step.cpp
 * \brief: core of the hydrology solution 
 */ 

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../io/io.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "./solutions.h"
#include "../modules/modules.h"
#include "../include/include.h"
#include "../solvers/solvers.h"

void hydrology_core_step(FemModel* femmodel,int step, IssmDouble time){
	
	bool modify_loads=true;

	if(VerboseSolution()) _pprintLine_("   computing water column");
	femmodel->SetCurrentConfiguration(HydrologyAnalysisEnum);
	solver_nonlinear(femmodel,modify_loads);

	/*transfer water column thickness to old water column thickness: */
	InputDuplicatex(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,WatercolumnEnum,WaterColumnOldEnum);

}
