/*!\file: controlconvergence.cpp
 * \brief: determine convergence of control_core solution
 */ 
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../io/io.h"
#include "../Container/Container.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../include/include.h"
#include "../modules/modules.h"
#include "./solutions.h"

bool controlconvergence(IssmDouble J, IssmDouble tol_cm){

	int i;
	bool converged=false;

	/*Has convergence been reached?*/
	if (!isnan(tol_cm) && J<tol_cm){
		converged=true;
		if(VerboseConvergence()) _pprintString_("      Convergence criterion reached: J = " << J << " < " << tol_cm);
	}

	return converged;
}
