/*!\file StringExternalResult.c
 * \brief: implementation of the StringExternalResult object
 */

/*header files: */
/*{{{*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*StringExternalResult constructors and destructor*/
/*FUNCTION StringExternalResult::StringExternalResult(){{{*/
StringExternalResult::StringExternalResult(){
	return;
}
/*}}}*/
/*FUNCTION StringExternalResult::StringExternalResult(int enum_type,IssmString value){{{*/
StringExternalResult::StringExternalResult(int in_id, int in_enum_type,char* in_value,int in_step, IssmPDouble in_time){

	id=in_id;
	enum_type=in_enum_type;
	value=xNew<char>(strlen(in_value)+1);
	xMemCpy<char>(value,in_value,(strlen(in_value)+1));
	step=in_step;
	time=in_time;
	
}
/*}}}*/
/*FUNCTION StringExternalResult::~StringExternalResult(){{{*/
StringExternalResult::~StringExternalResult(){
	xDelete<char>(value);
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION StringExternalResult::Echo {{{*/
void StringExternalResult::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION StringExternalResult::DeepEcho{{{*/
void StringExternalResult::DeepEcho(void){

	_printLine_("StringExternalResult:");
	_printLine_("   id: " << this->id);
	_printLine_("   enum:  " << this->enum_type << " (" << EnumToStringx(this->enum_type) << ")");
	_printLine_("   value: " << this->value);
	_printLine_("   step: " << this->step);
	_printLine_("   time: " << this->time);
}
/*}}}*/
/*FUNCTION StringExternalResult::Id{{{*/
int    StringExternalResult::Id(void){ return -1; }
/*}}}*/
/*FUNCTION StringExternalResult::MyRank{{{*/
int    StringExternalResult::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
/*FUNCTION StringExternalResult::ObjectEnum{{{*/
int StringExternalResult::ObjectEnum(void){

	return StringExternalResultEnum;

}
/*}}}*/
/*FUNCTION StringExternalResult::copy{{{*/
Object* StringExternalResult::copy() {
	
	return new StringExternalResult(this->id,this->enum_type,this->value,this->step,this->time);

}
/*}}}*/

/*StringExternalResult management: */
/*FUNCTION StringExternalResult::WriteData{{{*/
void   StringExternalResult::WriteData(FILE* fid,bool io_gather){

	int     length;
	int     type;
	char   *name      = NULL;
	extern  int my_rank;

	/*return if now on cpu 0: */
	if(my_rank)return;

	/*First write enum: */
	EnumToStringx(&name,this->enum_type);
	length=(strlen(name)+1)*sizeof(char);
	fwrite(&length,sizeof(int),1,fid);
	fwrite(name,length,1,fid);
	xDelete<char>(name);

	/*Now write time and step: */
	fwrite(&time,sizeof(IssmPDouble),1,fid);
	fwrite(&step,sizeof(int),1,fid);

	/*writing a string, type is 2: */
	type=2;
	fwrite(&type,sizeof(int),1,fid);
	
	length=(strlen(this->value)+1)*sizeof(char);
	fwrite(&length,sizeof(int),1,fid);
	fwrite(this->value,length,1,fid);

}
/*}}}*/
/*FUNCTION StringExternalResult::GetResultName{{{*/
void StringExternalResult::GetResultName(char**pname){
	EnumToStringx(pname,this->enum_type);
}
/*}}}*/
/*FUNCTION StringExternalResult::GetStep{{{*/
int StringExternalResult::GetStep(void){

	return this->step;
}
/*}}}*/
