/*!\file DoubleExternalResult.c
 * \brief: implementation of the DoubleExternalResult object
 */

/*header files: */
/*{{{*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*DoubleExternalResult constructors and destructor*/
/*FUNCTION DoubleExternalResult::DoubleExternalResult(){{{*/
DoubleExternalResult::DoubleExternalResult(){
	return;
}
/*}}}*/
/*FUNCTION DoubleExternalResult::DoubleExternalResult(int enum_type,IssmPDouble value){{{*/
DoubleExternalResult::DoubleExternalResult(int in_id, int in_enum_type,IssmPDouble in_value,int in_step, IssmPDouble in_time){

	id=in_id;
	enum_type=in_enum_type;
	value=in_value;
	step=in_step;
	time=in_time;
}
/*}}}*/
/*FUNCTION DoubleExternalResult::~DoubleExternalResult(){{{*/
DoubleExternalResult::~DoubleExternalResult(){
	return;
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION DoubleExternalResult::Echo {{{*/
void DoubleExternalResult::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION DoubleExternalResult::DeepEcho{{{*/
void DoubleExternalResult::DeepEcho(void){

	_printLine_("DoubleExternalResult:");
	_printLine_("   id: " << this->id);
	_printLine_("   enum:  " << this->enum_type << " (" << EnumToStringx(this->enum_type) << ")");
	_printLine_("   value: " << this->value);
	_printLine_("   step: " << this->step);
	_printLine_("   time: " << this->time);
}
/*}}}*/
/*FUNCTION DoubleExternalResult::Id{{{*/
int    DoubleExternalResult::Id(void){ return -1; }
/*}}}*/
/*FUNCTION DoubleExternalResult::MyRank{{{*/
int    DoubleExternalResult::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
/*FUNCTION DoubleExternalResult::ObjectEnum{{{*/
int DoubleExternalResult::ObjectEnum(void){

	return DoubleExternalResultEnum;

}
/*}}}*/
/*FUNCTION DoubleExternalResult::copy{{{*/
Object* DoubleExternalResult::copy() {
	
	return new DoubleExternalResult(this->id,this->enum_type,this->value,this->step,this->time);

}
/*}}}*/

/*DoubleExternalResult management: */
/*FUNCTION DoubleExternalResult::WriteData{{{*/
void   DoubleExternalResult::WriteData(FILE* fid,bool io_gather){

	int     length;
	int     type;
	int     size;
	char   *name    = NULL;
	extern  int my_rank;

	/*return if now on cpu 0: */
	if(my_rank)return;

	/*First write enum: */
	EnumToStringx(&name,this->enum_type);
	length=(strlen(name)+1)*sizeof(char);
	fwrite(&length,sizeof(int),1,fid);
	fwrite(name,length,1,fid);
	xDelete<char>(name);

	/*Now write time and step: */
	fwrite(&time,sizeof(IssmPDouble),1,fid);
	fwrite(&step,sizeof(int),1,fid);

	/*writing a IssmPDouble, type is 1, size is 1: */
	type=1;
	size=1;
	fwrite(&type,sizeof(int),1,fid);
	fwrite(&size,sizeof(int),1,fid);
	fwrite(&this->value,size*sizeof(IssmPDouble),1,fid);

}
/*}}}*/
/*FUNCTION DoubleExternalResult::GetResultName{{{*/
void DoubleExternalResult::GetResultName(char** pname){
	EnumToStringx(pname,this->enum_type);
}
/*}}}*/
/*FUNCTION DoubleExternalResult::GetStep{{{*/
int DoubleExternalResult::GetStep(void){

	return this->step;
}
/*}}}*/
