/*!\file BamgConvertMeshx
 */

#include "./BamgConvertMeshx.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../objects/objects.h"

using namespace bamg;
using namespace std;

int BamgConvertMeshx(BamgMesh* bamgmesh,BamgGeom* bamggeom,double* index,double* x,double* y,int nods,int nels){

	/*Intermediary*/
	int i,j,k;
	int verbose=0;
	int noerr=1;

	/*Options*/
	BamgOpts* bamgopts=NULL;
	bamgopts=new BamgOpts();

	// read mesh
	if(verbose) _printLine_("Reading mesh");
	Mesh Th(index,x,y,nods,nels); 

	//write mesh and geometry
	if (verbose) _printLine_("Write Geometry");
	Th.Gh.WriteGeometry(bamggeom,bamgopts);
	if (verbose) _printLine_("Write Mesh");
	Th.WriteMesh(bamgmesh,bamgopts);

	//clean up
	delete bamgopts;

	/*No error return*/
	return noerr;

}
