function displayparameters(md)
%DISPLAYPARAMETERS - display parameters
%
%   To avoid clobbering display.m with every field from model md, 
%   we create this routine that displays parameters from model md, 
%   only if requested.
%
%   Usage:
%      displayparameters(md)

fprintf('   Parameters:\n');

fprintf('\n      geometry:\n');
if isempty(md.surface), fprintf('         surface: N/A'); else fprintf('         surface [m]: (%i)\n',length(md.surface)); end
if isempty(md.thickness), fprintf('         thickness: N/A'); else fprintf('         thickness [m]: (%i)\n',length(md.thickness)); end
if isempty(md.bed), fprintf('         bed: N/A'); else fprintf('         bed [m]: (%i)\n',length(md.bed)); end
if isempty(md.firn_layer), fprintf('         firn_layer: N/A'); else fprintf('         firn_layer [m]: (%i)\n',length(md.firn_layer)); end
if strcmpi(md.type,'3d'), fprintf('         elementonbed: (%i)\n',length(md.elementonbed)); end
if strcmpi(md.type,'3d'), fprintf('         elementonsurface: (%i)\n',length(md.elementonsurface)); end
if strcmpi(md.type,'3d'), fprintf('         gridonbed: (%i)\n',length(md.gridonbed)); end
if strcmpi(md.type,'3d'), fprintf('         gridonsurface: (%i)\n',length(md.gridonsurface)); end

fprintf('\n      physical parameters:\n');
fprintf('         g: %g [m/s^2]\n',md.g);

fprintf('\n      Friction parameters (Sigma= drag^2 * Neff ^r * u ^s, with Neff=rho_ice*g*thickness+rho_ice*g*bed, r=q/p and s=1/p)\n');
fprintf('         drag_type: %i (0: none, 1:plastic, 2:viscous):\n',md.drag_type);
if isempty(md.drag), fprintf('         drag: N/A'); else fprintf('         drag: (%i)\n',length(md.drag)); end
fprintf('         drag_type: %i (0: none, 1:plastic, 2:viscous):\n',md.drag_type);
if isempty(md.p), fprintf('         p: N/A'); else fprintf('         p: (%i)\n',length(md.p)); end
if isempty(md.q), fprintf('         q: N/A'); else fprintf('         q: (%i)\n',length(md.q)); end
