function displaymesh(md)
%DISPLAYMESH - display mesh information
%
%   To avoid clobbering display.m with every field from model md, 
%   we create this routine that displays mesh information from model md, 
%   only if requested.
%
%   Usage:
%      displaymesh(md)

fprintf('   Mesh:\n'); 

if strcmpi(md.type,'3d'),

	fprintf('\n      Elements and nodes of the original 2d mesh:\n');
	fprintf('         numberofelements2d: %i (number of elements)\n',md.numberofelements2d);
	fprintf('         numberofgrids2d: %i (number of nodes)\n',md.numberofgrids2d); 
	fprintf('         elements2d: (%i-%i) (index into (x,y,z), coordinates of the grids)\n',md.numberofelements2d,size(md.elements2d,2)); 
	fprintf('         elements_type2d: (%i) (element types, according to number of grids)\n',md.numberofelements2d);
	fprintf('         x2d: (%i) (node x coordinates)\n',length(md.x2d));
	fprintf('         y2d: (%i) (node y coordinates)\n',length(md.y2d));
	fprintf('         z2d: (%i) (node z coordinates)\n',length(md.z2d));

	fprintf('\n      Elements and nodes of the extruded 3d mesh:\n');
else

	fprintf('\n      Elements and nodes:\n');
end

fprintf('         numberofelements: %i (number of elements)\n',md.numberofelements);
fprintf('         numberofgrids: %i (number of nodes)\n',md.numberofgrids); 
if ~isnan(md.dof), fprintf('      dof: %i (maximum number of dofs solved)\n',md.dof); end
fprintf('         elements: (%i-%i) (index into (x,y,z), coordinates of the grids)\n',md.numberofelements,size(md.elements,2)); 
fprintf('         elements_type: (%i) (element types, according to number of grids)\n',md.numberofelements);
fprintf('         x: (%i) (node x coordinates)\n',length(md.x));
fprintf('         y: (%i) (node y coordinates)\n',length(md.y));
fprintf('         z: (%i) (node z coordinates)\n',length(md.z));
fprintf('         numlayers: %i (number of extrusion layers)\n',md.numlayers);

fprintf('\n      Properties:\n');
fprintf('         type: %s\n',md.type);
fprintf('         Penalties: (%i-%i))\n',size(md.penalties,1),size(md.penalties,2));
fprintf('         gridonbed: (%i) (lower nodes flags list)\n',length(md.gridonbed));
fprintf('         gridonsurface: (%i) (upper nodes flags list)\n',length(md.gridonsurface));
fprintf('         elementonbed: (%i) (lower elements flags list)\n',length(md.elementonbed));
fprintf('         elementonsurface: (%i) (upper elements flags list)\n',length(md.elementonsurface));
