function displaybc(md)
%DISPLAYBC - display of the boundary conditions fileds
%
%   to avoid clobbering display.m with every field from model md, 
%   we create this routine that displays boundary conditions  from model md, 
%   only if requested.
%
%   Usage:
%      displaybc(md)

fprintf('   Boundary conditions:\n');

fprintf('\n      geography:\n');
fprintf('         gridonboundary: (%i)\n',length(md.gridonboundary));
fprintf('         elementoniceshelf: (%i)\n',length(md.elementoniceshelf));
fprintf('         gridoniceshelf: (%i)\n',length(md.gridoniceshelf));
fprintf('         elementonicesheet: (%i)\n',length(md.elementonicesheet));
fprintf('         gridonicesheet: (%i)\n',length(md.gridonicesheet));

fprintf('\n      diagnostic:\n');
fprintf('         gridondirichlet_diag: (%i)\n',length(md.gridondirichlet_diag));
fprintf('         dirichletvalues_diag [m/a]: (%i,%i)\n',length(md.dirichletvalues_diag),2);
fprintf('         segmentonneumann_diag: (%i)\n',length(md.segmentonneumann_diag));
fprintf('         neumannvalues_diag [N]: (%i)\n',length(md.neumannvalues_diag));

fprintf('\n      prognostic:\n');
fprintf('         gridondirichlet_prog: (%i)\n',length(md.gridondirichlet_prog));
fprintf('         dirichletvalues_prog [m/a]: (%i)\n',length(md.dirichletvalues_prog));
fprintf('         segmentonneumann_prog (flux): (%i)\n',length(md.segmentonneumann_prog));
fprintf('         neumannvalues_prog [N]: (%i)\n',length(md.neumannvalues_prog));
fprintf('         segmentonneumann_prog2 (thickness gradient): (%i)\n',length(md.segmentonneumann_prog2));
fprintf('         neumannvalues_prog2 [N]: (%i)\n',length(md.neumannvalues_prog2));

fprintf('\n      thermal:\n');
fprintf('         gridondirichlet_thermal: (%i)\n',length(md.gridondirichlet_thermal));
fprintf('         dirichletvalues_thermal [K]: (%i)\n',length(md.dirichletvalues_thermal));
fprintf('         melting [m/a]: (%i)\n',length(md.melting));
