function displayresults(md)
%DISPLAYRESULTS - display results
%
%   To avoid clobbering display.m with every field from model md, 
%   we create this routine that displays results from model md, 
%   only if requested.
%
%   Usage:
%      displayresults(md)

fprintf('   Results:\n');

%call struct_display recursively on md.results
struct_display(md.results,'      ');

%display output parameters
fprintf('\n      output parameters:\n');
if ~isstruct(md.stress), fprintf('         stress: N/A\n'); 
else 
	fprintf('         stress [Pa]:');
	struct_display(md.stress,'         ');
end
if ~isstruct(md.deviatoricstress), fprintf('         deviatoricstress: N/A\n'); 
else 
	fprintf('         deviatoricstress [Pa]:');
	struct_display(md.deviatoricstress,'         ');
end
if ~isstruct(md.strainrate), fprintf('         strainrate: N/A\n'); 
else 
           fprintf('         strainrate [1/a]:');
		  struct_display(md.strainrate,'         ');
end
end

function struct_display(structure,offset)
	structure_fields=fields(structure);
	for i=1:length(structure_fields),
		%recursive call if necessary
		field=eval(['structure.' structure_fields{i}]);
		if isstruct(field),
			fprintf('\n%s\n',[offset structure_fields{i} ':']);
			struct_display(field,[offset '   ']);
		else
			fprintf('%s\n',[offset structure_fields{i} ': (' num2str(size(field,1))  ')' ]);
		end
	end
end
