function displayparallel(md)
%DISPLAYPARALLEL - display parallel computation parameters
%
%   To avoid clobbering display.m with every field from model md, 
%   we create this routine that displays all fields related to
%   parallel computation from model md, only if requested.
%
%   Usage:
%      displayparallel(md)

fprintf('\n      parallelisation:\n');
fprintf('         cluster: %s      (set to ''cluster_name'' to run in cluster, ''none'' to run serially)\n',md.cluster);
fprintf('         np: %i      (number of CPUS requested on cluster)\n',md.np);
fprintf('         exclusive: %i      (set to 1 if CPUS used are not to be shared with other users, 0 otherwise)\n',md.exclusive);
fprintf('         time: %i      (amount of time requested on cluster)\n',md.time); 
fprintf('         alloc_cleanup: %i      (allocation cleanup before starting a job, default 1)\n',md.alloc_cleanup); 
fprintf('         waitonlock: %i      (wait for batch results 1, or return 0. default is to return )\n',md.waitonlock); 
fprintf('         queue: %s      (special queue name on cluster? default is '''')\n',md.queue); fprintf('\n      solver options:\n');

fprintf('\n      solver options:\n');
fprintf('         ice\n');
fprintf('            solver_type: %s  (solver type for Ice: ''lu'' or ''cholesky'')\n',md.solver_type);
fprintf('         cielo\n');
fprintf('            solverstring: %s \n            (solver string for Petsc. See solversetto... routines. Default is asm)\n',md.solverstring); 
