function displaycontrol(md)
%DISPLAYCONTROL - display control parameters
%
%   To avoid clobbering display.m with every field from model md, 
%   we create this routine that displays control parameters from model md, 
%   only if requested.
%
%   Usage:
%      displaycontrol(md)

disp(sprintf('      ''%s''','control'));
%control type
control_string='';
for i=1:length(md.control_type),
	parameter=md.control_type{i};
	%check this parameter is a field from model! 
	if ~isfield(struct(md),parameter),
		error('displaysolutionparameters error message: one of the control type parameters does not exist!');
	end
	control_string=[control_string parameter ' and '];
end
control_string=control_string(1:length(control_string)-5);
disp(sprintf('         control_type: %s %s',control_string,'(parameter where inverse control is carried out; ex: ''drag'', or ''B'')'));
disp(sprintf('         fit: (%i)      (''absolute: 0'', ''relative: 1'', or ''logarithmic: 2''. default is ''absolute: 0'', for each optimization steps)',length(md.fit)));
disp(sprintf('         meanvel: %g      (velocity scaling factor when evaluating relative or logarithmic misfit)',md.meanvel));
disp(sprintf('         epsvel: %g      ( for relative fit, avoids misfit becoming infinity, for logarithmic fit, threshold for velocity)',md.epsvel));
disp(sprintf('         nsteps: %i      (number of optimization searches)',md.nsteps));
disp(sprintf('         optscal: (%i %i)      (scaling factor on gradient direction during optimization, for each optimization step)',size(md.optscal,1),size(md.optscal,2)));
disp(sprintf('         mincontrolconstraint: %g      (minimum contraint for the controlled parameters)',md.mincontrolconstraint));
disp(sprintf('         maxcontrolconstraint: %g      (maximum contraint for the controlled parameters)',md.maxcontrolconstraint));
disp(sprintf('         maxiter: (%i)      (maximum iterations during each optimization step)',length(md.maxiter)));
disp(sprintf('         tolx: %f      (minimum tolerance which will stop one optimization search)',md.tolx));
disp(sprintf('         plot: %i      (visualization of the results of each iteration yes -> 1 no -> 0. Default is 1)',md.plot));
