/*!\file InterpFromGridToMesh.c
 * \brief: data interpolation from a list of (x,y,values) into mesh vertices
 
	InterpFromGridToMesh.c

	usage:
	data_mesh=InterpFromGridToMesh(x,y,data,x_mesh,y_mesh);
	
	where:

		input:
		x,y: coordinates of matrix data
		data - matrix holding the data to be interpolated onto the mesh.
		x_mesh,y_mesh: coordinates of the mesh vertices onto which we interpolate.
		
		output: 
		data_mesh:  vector of mesh interpolated data.
*/
	
#include "./InterpFromGridToMesh.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]) {

	int i,j;

	/*input: */
	double* x=NULL;
	double* y=NULL;
	int     x_rows,y_rows;
	double* data=NULL; 
	int     data_rows,data_cols;
	double* x_mesh=NULL;
	double* y_mesh=NULL;
	int     x_mesh_rows,y_mesh_rows;
	double  default_value;
	int     interpolationenum;

	/* output: */
	Vector*  data_mesh=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	//CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&InterpFromGridToMeshUsage);
	if((nlhs!=NLHS) || (nrhs!=6 && nrhs!=7)){
		InterpFromGridToMeshUsage();
		_error_("usage. See above");
	}

	/*Input datasets: */
	FetchData(&x,&x_rows,NULL,XHANDLE);
	FetchData(&y,&y_rows,NULL,YHANDLE);
	FetchData(&data,&data_rows,&data_cols,DATAHANDLE);
	FetchData(&x_mesh,&x_mesh_rows,NULL,XMESHHANDLE);
	FetchData(&y_mesh,&y_mesh_rows,NULL,YMESHHANDLE);
	FetchData(&default_value,DEFAULTHANDLE);

	/* Run core computations: */
	if(nrhs==7){
		FetchData(&interpolationenum,INTERPENUM);
		InterpFromGridToMeshx(&data_mesh, x, x_rows,  y, y_rows, data, data_rows,data_cols, x_mesh, y_mesh, x_mesh_rows,default_value,interpolationenum);
	}
	else{
		InterpFromGridToMeshx(&data_mesh, x, x_rows,  y, y_rows, data, data_rows,data_cols, x_mesh, y_mesh, x_mesh_rows,default_value);
	}

	/*Write data: */
	WriteData(DATAMESH,data_mesh);

	/*end module: */
	MODULEEND();
}

void InterpFromGridToMeshUsage(void)
{
	_printf_(true,"INTERPFROMGRIDTOMESH - interpolation from a grid onto a list of points\n");
	_printf_(true,"\n");
	_printf_(true,"   This function is a multi-threaded mex file that interpolates a field\n");
	_printf_(true,"   defined on a grid onto a list of points\n");
	_printf_(true,"\n");
	_printf_(true,"   Usage:\n");
	_printf_(true,"      data_mesh=InterpFromGridToMesh(x,y,data,x_mesh,y_mesh,default_value);\n");
	_printf_(true,"\n");
	_printf_(true,"      data: matrix holding the data to be interpolated onto the mesh.\n");
	_printf_(true,"      x,y: coordinates of matrix data. (x and y must be in increasing order)\n");
	_printf_(true,"      x_mesh,y_mesh: coordinates of the points onto which we interpolate.\n");
	_printf_(true,"      default_value: default value if no data is found (holes).\n");
	_printf_(true,"      data_mesh: vector of mesh interpolated data.\n");
	_printf_(true,"\n");
	_printf_(true,"   Example:\n");
	_printf_(true,"      load('velocities.mat');\n");
	_printf_(true,"      md.inversion.vx_obs=InterpFromGridToMesh(x_n,y_m,vx,md.mesh.x,md.mesh.y,0);\n");
	_printf_(true,"\n");
}
