/*! \file TriaP1Input.h 
 *  \brief: header file for TriaP1Input object
 */


#ifndef _TRIAP1INPUT_H_
#define _TRIAP1INPUT_H_

/*Headers:*/
/*{{{*/
#include "./Input.h"
#include "../Elements/TriaRef.h"
class GaussTria;
/*}}}*/

class TriaP1Input: public Input,public TriaRef{

	public:
		/*just hold 3 values for 3 vertices: */
		int    enum_type;
		IssmPDouble values[3];

		/*TriaP1Input constructors, destructors: {{{*/
		TriaP1Input();
		TriaP1Input(int enum_type,IssmPDouble* values);
		~TriaP1Input();
		/*}}}*/
		/*Object virtual functions definitions:{{{ */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*TriaP1Input management: {{{*/
		int   InstanceEnum();
		Input* SpawnTriaInput(int* indices);
		Input* PointwiseDivide(Input* inputB){_error2_("not implemented yet");};
		Input* PointwiseMin(Input* inputB);
		Input* PointwiseMax(Input* inputB);
		ElementResult* SpawnResult(int step, IssmPDouble time);
		void AddTimeValues(IssmPDouble* values,int step,IssmPDouble time){_error2_("not supported yet");};
		void Configure(Parameters* parameters);
		/*}}}*/
		/*numerics: {{{*/
		void GetInputValue(bool* pvalue){_error2_("not implemented yet");}
		void GetInputValue(int* pvalue){_error2_("not implemented yet");}
		void GetInputValue(IssmPDouble* pvalue){_error2_("not implemented yet");}
		void GetInputValue(IssmPDouble* pvalue,GaussTria* gauss);
		void GetInputValue(IssmPDouble* pvalue,GaussTria* gauss,IssmPDouble time){_error2_("not implemented yet");};
		void GetInputValue(IssmPDouble* pvalue,GaussPenta* gauss){_error2_("not implemented yet");};
		void GetInputValue(IssmPDouble* pvalue,GaussTria* gauss ,int index){_error2_("not implemented yet");};
		void GetInputValue(IssmPDouble* pvalue,GaussPenta* gauss,int index){_error2_("not implemented yet");};
		void GetInputDerivativeValue(IssmPDouble* derivativevalues, IssmPDouble* xyz_list, GaussTria* gauss);
		void GetInputDerivativeValue(IssmPDouble* derivativevalues, IssmPDouble* xyz_list, GaussPenta* gauss){_error2_("not implemented yet");};
		void GetInputAverage(IssmPDouble* pvalue);
		void GetVxStrainRate2d(IssmPDouble* epsilonvx,IssmPDouble* xyz_list, GaussTria* gauss);
		void GetVyStrainRate2d(IssmPDouble* epsilonvy,IssmPDouble* xyz_list, GaussTria* gauss);
		void GetVxStrainRate3d(IssmPDouble* epsilonvx,IssmPDouble* xyz_list, GaussPenta* gauss){_error2_("not implemented yet");};
		void GetVyStrainRate3d(IssmPDouble* epsilonvy,IssmPDouble* xyz_list, GaussPenta* gauss){_error2_("not implemented yet");};
		void GetVzStrainRate3d(IssmPDouble* epsilonvz,IssmPDouble* xyz_list, GaussPenta* gauss){_error2_("not implemented yet");};
		void GetVxStrainRate3dPattyn(IssmPDouble* epsilonvx,IssmPDouble* xyz_list, GaussPenta* gauss){_error2_("not implemented yet");};
		void GetVyStrainRate3dPattyn(IssmPDouble* epsilonvy,IssmPDouble* xyz_list, GaussPenta* gauss){_error2_("not implemented yet");};
		void ChangeEnum(int newenumtype);

		void SquareMin(IssmPDouble* psquaremin, bool process_units,Parameters* parameters);
		void ConstrainMin(IssmPDouble minimum);
		void Scale(IssmPDouble scale_factor);
		void ArtificialNoise(IssmPDouble min,IssmPDouble max);
		void AXPY(Input* xinput,IssmPDouble scalar);
		void Constrain(IssmPDouble cm_min, IssmPDouble cm_max);
		IssmPDouble InfinityNorm(void);
		IssmPDouble Max(void);
		IssmPDouble MaxAbs(void);
		IssmPDouble Min(void);
		IssmPDouble MinAbs(void);
		void Extrude(void){_error2_("not supported yet");};
		void VerticallyIntegrate(Input* thickness_input){_error2_("not supported yet");};
		void GetVectorFromInputs(Vector* vector,int* doflist);
		void GetValuesPtr(IssmPDouble** pvalues,int* pnum_values);
		/*}}}*/

};
#endif  /* _TRIAP1INPUT_H */
