/*! \file BoolInput.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _BOOLINPUT_H_
#define _BOOLINPUT_H_

/*Headers:*/
/*{{{*/
#include "./Input.h"
#include "../../include/include.h"
class GaussTria;
/*}}}*/

class BoolInput: public Input{

	public:
		/*just hold 3 values for 3 vertices: */
		int    enum_type;
		IssmBool value;

		/*BoolInput constructors, destructors: {{{*/
		BoolInput();
		BoolInput(int enum_type,IssmBool value);
		~BoolInput();
		/*}}}*/
		/*Object virtual functions definitions:{{{ */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*BoolInput management: {{{*/
		int   InstanceEnum();
		Input* SpawnTriaInput(int* indices);
		Input* PointwiseDivide(Input* inputB){_error2_("not implemented yet");};
		Input* PointwiseMin(Input* inputB){_error2_("not implemented yet");};
		Input* PointwiseMax(Input* inputB){_error2_("not implemented yet");};
		ElementResult* SpawnResult(int step, IssmPDouble time);
		void Configure(Parameters* parameters);
		void AddTimeValues(IssmPDouble* values,int step,IssmPDouble time){_error2_("not supported yet");};
		/*}}}*/
		/*numerics: {{{*/
		void GetInputValue(bool* pvalue);
		void GetInputValue(int* pvalue);
		void GetInputValue(IssmPDouble* pvalue);
		void GetInputValue(IssmPDouble* pvalue,GaussTria* gauss);
		void GetInputValue(IssmPDouble* pvalue,GaussTria* gauss,IssmPDouble time){_error2_("not implemented yet");};
		void GetInputValue(IssmPDouble* pvalue,GaussPenta* gauss);
		void GetInputValue(IssmPDouble* pvalue,GaussTria* gauss ,int index){_error2_("not implemented yet");};
		void GetInputValue(IssmPDouble* pvalue,GaussPenta* gauss ,int index){_error2_("not implemented yet");};
		void GetInputDerivativeValue(IssmPDouble* derivativevalues, IssmPDouble* xyz_list, GaussTria* gauss);
		void GetInputDerivativeValue(IssmPDouble* derivativevalues, IssmPDouble* xyz_list, GaussPenta* gauss);
		void GetInputAverage(IssmPDouble* pvalue){_error2_("not implemented yet");};
		void GetVxStrainRate2d(IssmPDouble* epsilonvx,IssmPDouble* xyz_list, GaussTria* gauss){_error2_("not implemented yet");};
		void GetVyStrainRate2d(IssmPDouble* epsilonvy,IssmPDouble* xyz_list, GaussTria* gauss){_error2_("not implemented yet");};
		void GetVxStrainRate3d(IssmPDouble* epsilonvx,IssmPDouble* xyz_list, GaussPenta* gauss){_error2_("not implemented yet");};
		void GetVyStrainRate3d(IssmPDouble* epsilonvy,IssmPDouble* xyz_list, GaussPenta* gauss){_error2_("not implemented yet");};
		void GetVzStrainRate3d(IssmPDouble* epsilonvz,IssmPDouble* xyz_list, GaussPenta* gauss){_error2_("not implemented yet");};
		void GetVxStrainRate3dPattyn(IssmPDouble* epsilonvx,IssmPDouble* xyz_list, GaussPenta* gauss){_error2_("not implemented yet");};
		void GetVyStrainRate3dPattyn(IssmPDouble* epsilonvy,IssmPDouble* xyz_list, GaussPenta* gauss){_error2_("not implemented yet");};
		void ChangeEnum(int newenumtype);
		void SquareMin(IssmPDouble* psquaremin, bool process_units,Parameters* parameters);
		void ConstrainMin(IssmPDouble minimum){_error2_("not implemented yet");};
		IssmPDouble InfinityNorm(void){_error2_("InfinityNorm not implemented for booleans");};
		IssmPDouble Max(void){_error2_("Max not implemented for booleans");};
		IssmPDouble MaxAbs(void){_error2_("Max not implemented for booleans");};
		IssmPDouble Min(void){_error2_("Min not implemented for booleans");};
		IssmPDouble MinAbs(void){_error2_("Min not implemented for booleans");};
		void Scale(IssmPDouble scale_factor);
		void ArtificialNoise(IssmPDouble min,IssmPDouble max){_error2_("not implemented yet");};
		void AXPY(Input* xinput,IssmPDouble scalar);
		void Constrain(IssmPDouble cm_min, IssmPDouble cm_max);
		void Extrude(void);
		void VerticallyIntegrate(Input* thickness_input){_error2_("not supported yet");};
		void GetVectorFromInputs(Vector* vector,int* doflist);
		void GetValuesPtr(IssmPDouble** pvalues,int* pnum_values);
		/*}}}*/

};
#endif  /* _BOOLINPUT_H */
